/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import com.northernwall.hadrian.domain.DcStats;
import java.util.HashMap;
import java.util.Map;

public class Stats {
    private int year;
    private int week;
    private double services;
    private double deployableModules;
    private double libraryModules;
    private double simulatorModules;
    private double testModules;
    private double allModulesPerService;
    private Map<String, DcStats> dcStats;

    public Stats(int year, int week, double services, double deployableModules, double libraryModules, double simulatorModules, double testModules) {
        this.year = year;
        this.week = week;
        while (this.week > 52) {
            ++this.year;
            this.week -= 52;
        }
        this.services = services;
        this.deployableModules = deployableModules;
        this.libraryModules = libraryModules;
        this.simulatorModules = simulatorModules;
        this.testModules = testModules;
        this.allModulesPerService = services == 0.0 ? 0.0 : (deployableModules + libraryModules + simulatorModules + testModules) / services;
        this.dcStats = new HashMap<String, DcStats>();
    }

    public Stats(Stats baseStats, int addWeeks) {
        this.year = baseStats.year;
        this.week = baseStats.week + addWeeks;
        while (this.week > 52) {
            ++this.year;
            this.week -= 52;
        }
        this.services = baseStats.services;
        this.deployableModules = baseStats.deployableModules;
        this.libraryModules = baseStats.libraryModules;
        this.simulatorModules = baseStats.simulatorModules;
        this.testModules = baseStats.testModules;
        this.allModulesPerService = this.services == 0.0 ? 0.0 : (this.deployableModules + this.libraryModules + this.simulatorModules + this.testModules) / this.services;
        this.dcStats = new HashMap<String, DcStats>();
        for (String dc : baseStats.dcStats.keySet()) {
            DcStats temp = baseStats.dcStats.get(dc);
            this.dcStats.put(dc, new DcStats(baseStats, temp, addWeeks));
        }
    }

    public int getYear() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    public double getServices() {
        return this.services;
    }

    public double getDeployableModules() {
        return this.deployableModules;
    }

    public double getLibraryModules() {
        return this.libraryModules;
    }

    public double getSimulatorModules() {
        return this.simulatorModules;
    }

    public double getTestModules() {
        return this.testModules;
    }

    public double getAllModulesPerService() {
        return this.allModulesPerService;
    }

    public void addDcStat(String dc, DcStats stats) {
        this.dcStats.put(dc, stats);
    }

    public DcStats getDcStats(String dc) {
        return this.dcStats.get(dc);
    }
}

