/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import com.northernwall.hadrian.domain.Stats;

public class DcStats {
    private double deployableHosts;
    private double deployableHostsRate;
    private double simulatorHosts;
    private double simulatorHostsRate;
    private double allHostsPerService;
    private double deployableHostsPerDeployableModules;
    private double simulatorHostsPerSimulatorModules;
    private double deployableCpu;
    private double deployableCpuRate;
    private double deployableCpusPerDeployableHosts;
    private double deployableCpusPerDeployableModules;

    public DcStats(Stats stats, double deployableHosts, double deployableHostsRate, double simulatorHosts, double simulatorHostsRate, double deployableCpu, double deployableCpuRate) {
        this.deployableHosts = deployableHosts;
        this.deployableHostsRate = deployableHostsRate;
        this.simulatorHosts = simulatorHosts;
        this.simulatorHostsRate = simulatorHostsRate;
        this.deployableHostsPerDeployableModules = deployableHosts / stats.getDeployableModules();
        this.simulatorHostsPerSimulatorModules = simulatorHosts / stats.getSimulatorModules();
        this.deployableCpu = deployableCpu;
        this.deployableCpuRate = deployableCpuRate;
        this.allHostsPerService = (deployableHosts + simulatorHosts) / stats.getServices();
        this.deployableCpusPerDeployableHosts = deployableCpu / deployableHosts;
        this.deployableCpusPerDeployableModules = deployableCpu / stats.getDeployableModules();
    }

    DcStats(Stats stats, DcStats baseDcStats, int addWeeks) {
        this.deployableHosts = Math.round(baseDcStats.deployableHosts + baseDcStats.deployableHostsRate * (double)addWeeks);
        this.deployableHostsRate = baseDcStats.deployableHostsRate;
        this.simulatorHosts = Math.round(baseDcStats.simulatorHosts + baseDcStats.simulatorHostsRate * (double)addWeeks);
        this.simulatorHostsRate = baseDcStats.simulatorHostsRate;
        this.deployableHostsPerDeployableModules = this.deployableHosts / stats.getDeployableModules();
        this.simulatorHostsPerSimulatorModules = this.simulatorHosts / stats.getSimulatorModules();
        this.deployableCpu = Math.round(baseDcStats.deployableCpu + baseDcStats.deployableCpuRate * (double)addWeeks);
        this.deployableCpuRate = baseDcStats.deployableCpuRate;
        this.allHostsPerService = (this.deployableHosts + this.simulatorHosts) / stats.getServices();
        this.deployableCpusPerDeployableHosts = this.deployableCpu / this.deployableHosts;
        this.deployableCpusPerDeployableModules = this.deployableCpu / stats.getDeployableModules();
    }

    public double getDeployableHosts() {
        return this.deployableHosts;
    }

    public double getDeployableHostsRate() {
        return this.deployableHostsRate;
    }

    public double getSimulatorHosts() {
        return this.simulatorHosts;
    }

    public double getSimulatorHostsRate() {
        return this.simulatorHostsRate;
    }

    public double getAllHostsPerService() {
        return this.allHostsPerService;
    }

    public double getDeployableHostsPerDeployableModules() {
        return this.deployableHostsPerDeployableModules;
    }

    public double getSimulatorHostsPerSimulatorModules() {
        return this.simulatorHostsPerSimulatorModules;
    }

    public double getDeployableCpu() {
        return this.deployableCpu;
    }

    public double getDeployableCpuRate() {
        return this.deployableCpuRate;
    }

    public double getDeployableCpusPerDeployableHosts() {
        return this.deployableCpusPerDeployableHosts;
    }

    public double getDeployableCpusPerDeployableModules() {
        return this.deployableCpusPerDeployableModules;
    }
}

