/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.GitMode;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAccessUpdater.class);

    public static void update(DataAccess dataAccess, Config config) {
        String version = dataAccess.getVersion();
        if (version == null) {
            dataAccess.setVersion("1.6");
            DataAccessUpdater.update(dataAccess, config);
        } else if (!version.equals("1.6")) {
            LOGGER.info("Upgrading DB version to 1.6");
            DataAccessUpdater.fixGitMode(dataAccess, config);
            dataAccess.setVersion("1.6");
            DataAccessUpdater.update(dataAccess, config);
        }
        DataAccessUpdater.fixHost(dataAccess);
        LOGGER.info("Current DB version is {}, no upgrade required.", (Object)version);
    }

    private static void fixGitMode(DataAccess dataAccess, Config config) {
        List<Service> services = dataAccess.getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Module> modules;
                boolean changed = false;
                if (service.getScope() == null && config.scopes != null && !config.scopes.isEmpty()) {
                    service.setScope(config.scopes.get(0));
                    changed = true;
                }
                if ((modules = dataAccess.getModules(service.getServiceId())) != null && !modules.isEmpty()) {
                    LOGGER.info("Upgrading service {} ({}), with {} modules", new Object[]{service.getServiceName(), service.getGitMode(), modules.size()});
                    block4: for (Module module : modules) {
                        switch (module.getModuleType()) {
                            case Test: {
                                if (service.getTestStyle() == null) {
                                    service.setTestStyle(module.getTestStyle());
                                    if (module.getTestStyle().equals("Script")) {
                                        service.setTestHostname(module.getHostname());
                                        service.setTestRunAs(module.getRunAs());
                                        service.setTestDeploymentFolder(module.getDeploymentFolder());
                                        service.setTestCmdLine(module.getStartCmdLine());
                                    }
                                    changed = true;
                                } else {
                                    LOGGER.warn("!!!!! found second test module, {}!", (Object)module.getModuleName());
                                }
                                dataAccess.deleteModule(service.getServiceId(), module.getModuleId());
                                continue block4;
                            }
                        }
                        if (service.getMavenGroupId() != null) continue;
                        service.setMavenGroupId(module.getMavenGroupId());
                        changed = true;
                    }
                    if (service.getTestStyle() == null) {
                        service.setTestStyle("Maven");
                        changed = true;
                    }
                    if (service.getGitMode() == GitMode.Flat) {
                        if (modules.size() > 1) {
                            LOGGER.warn("!!!!! {} modules for flat service {}!", (Object)modules.size(), (Object)service.getServiceName());
                        }
                        Module module = modules.get(0);
                        service.setGitProject(module.getGitProject());
                        service.setGitMode(GitMode.Consolidated);
                        changed = true;
                    }
                } else {
                    LOGGER.info("Upgrading service {} ({}), with zero modules", (Object)service.getServiceName(), (Object)service.getGitMode());
                    if (service.getGitMode() == GitMode.Flat) {
                        LOGGER.warn("!!!!! service {} is flat and has no modules, Git Project will be null!", (Object)service.getServiceName());
                    }
                }
                if (!changed) continue;
                dataAccess.saveService(service);
            }
        }
    }

    private static void fixHost(DataAccess dataAccess) {
        int serviceCount = 0;
        int hostCount = 0;
        List<Service> services = dataAccess.getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                dataAccess.backfillService(service);
                ++serviceCount;
                List<Host> hosts = dataAccess.getHosts(service.getServiceId());
                if (hosts == null || hosts.isEmpty()) continue;
                for (Host host : hosts) {
                    dataAccess.backfillHostName(host);
                    ++hostCount;
                }
            }
        }
        LOGGER.info("Backfilled {} service, {} hosts", (Object)serviceCount, (Object)hostCount);
    }

    private DataAccessUpdater() {
    }
}

