/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.calendar.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.calendar.Calendar;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.calendar.CalendarHelperFactory;
import com.northernwall.hadrian.calendar.google.GoogleCalendarHelper;
import com.northernwall.hadrian.calendar.simple.SimpleCalendarHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCalendarHelperFactory
implements CalendarHelperFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleCalendarHelperFactory.class);

    @Override
    public CalendarHelper create(Parameters parameters, OkHttpClient client) {
        try {
            String appName = parameters.getString("calendarHelper.google.appName", "service-delivery-tool");
            String accountId = parameters.getString("calendarHelper.google.accountId", null);
            if (accountId == null || accountId.isEmpty()) {
                LOGGER.error("{} can not be null or empty", (Object)"calendarHelper.google.accountId");
                return new SimpleCalendarHelper();
            }
            String privateKeyId = parameters.getString("calendarHelper.google.privateKeyId", null);
            if (privateKeyId == null || privateKeyId.isEmpty()) {
                LOGGER.error("{} can not be null or empty", (Object)"calendarHelper.google.privateKeyId");
                return new SimpleCalendarHelper();
            }
            PrivateKey privateKey = this.getPemPrivateKey(parameters);
            if (privateKey == null) {
                LOGGER.error("{} can not be null or empty", (Object)"calendarHelper.google.pemFile");
                return new SimpleCalendarHelper();
            }
            JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)jsonFactory).setServiceAccountId(accountId).setServiceAccountPrivateKeyId(privateKeyId).setServiceAccountPrivateKey(privateKey).setServiceAccountScopes(Collections.singleton("https://www.googleapis.com/auth/calendar")).build();
            Calendar calendarClient = new Calendar.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(appName).build();
            LOGGER.info("Finished building GoogleCalendarHelper successfully");
            return new GoogleCalendarHelper(calendarClient, parameters);
        }
        catch (IOException ex) {
            LOGGER.error("IO Exception while building GoogleCalendarHelper", (Throwable)ex);
            return new SimpleCalendarHelper();
        }
        catch (GeneralSecurityException ex) {
            LOGGER.error("General Security Exception while building GoogleCalendarHelper", (Throwable)ex);
            return new SimpleCalendarHelper();
        }
    }

    public PrivateKey getPemPrivateKey(Parameters parameters) throws GeneralSecurityException {
        String temp = parameters.getString("calendarHelper.google.pemFile", null);
        if (temp == null || temp.isEmpty()) {
            return null;
        }
        byte[] decoded = Base64.getDecoder().decode(temp);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }
}

