/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.access.simple;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.access.simple.SimpleSession;
import com.northernwall.hadrian.domain.User;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSessionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSessionStore.class);
    private final AccessHelper accessHelper;
    private final Map<String, SimpleSession> sessions;

    public SimpleSessionStore(AccessHelper accessHelper) {
        this.accessHelper = accessHelper;
        this.sessions = new HashMap<String, SimpleSession>();
    }

    public String createUserSession(String username) {
        SimpleSession session = new SimpleSession(username, System.currentTimeMillis() + 86400000L);
        this.sessions.put(session.getSessionId(), session);
        User user = this.accessHelper.getUser(username);
        LOGGER.info("login passed for {}, session {} started", (Object)user.getUsername(), (Object)session.getSessionId());
        return session.getSessionId();
    }

    public User getUserForSession(String sessionId) {
        SimpleSession session = this.sessions.get(sessionId);
        if (session == null) {
            LOGGER.warn("Could not find user sesion with ID {}", (Object)sessionId);
            return null;
        }
        if (session.getEndDateTime() < System.currentTimeMillis()) {
            LOGGER.warn("Trying to use session {} which has expried", (Object)sessionId);
            this.sessions.remove(sessionId);
            return null;
        }
        String username = session.getUsername();
        User user = this.accessHelper.getUser(username);
        return user;
    }
}

