/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.Hadrian;
import com.northernwall.hadrian.access.AccessHandlerFactory;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.calendar.CalendarHelperFactory;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.DataAccessFactory;
import com.northernwall.hadrian.db.DataAccessUpdater;
import com.northernwall.hadrian.details.HostDetailsHelper;
import com.northernwall.hadrian.details.HostDetailsHelperFactory;
import com.northernwall.hadrian.details.VipDetailsHelper;
import com.northernwall.hadrian.details.VipDetailsHelperFactory;
import com.northernwall.hadrian.module.ModuleArtifactHelper;
import com.northernwall.hadrian.module.ModuleArtifactHelperFactory;
import com.northernwall.hadrian.module.ModuleConfigHelper;
import com.northernwall.hadrian.module.ModuleConfigHelperFactory;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.dsh.metrics.JvmMetrics;
import org.dsh.metrics.MetricRegistry;
import org.dsh.metrics.listeners.ConsoleListener;
import org.dsh.metrics.listeners.KairosDBListener;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadrianBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadrianBuilder.class);
    private final Parameters parameters;
    private OkHttpClient client;
    private ConfigHelper configHelper;
    private DataAccess dataAccess;
    private ModuleArtifactHelper moduleArtifactHelper;
    private ModuleConfigHelper moduleConfigHelper;
    private AccessHelper accessHelper;
    private HostDetailsHelper hostDetailsHelper;
    private VipDetailsHelper vipDetailsHelper;
    private Handler accessHandler;
    private CalendarHelper calendarHelper;
    private MetricRegistry metricRegistry;

    public static HadrianBuilder create(Parameters parameters) {
        return new HadrianBuilder(parameters);
    }

    private HadrianBuilder(Parameters parameters) {
        this.parameters = parameters;
    }

    public HadrianBuilder setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        return this;
    }

    public HadrianBuilder setModuleArtifactHelper(ModuleArtifactHelper moduleArtifactHelper) {
        this.moduleArtifactHelper = moduleArtifactHelper;
        return this;
    }

    public HadrianBuilder setAccessHandler(Handler accessHandler) {
        this.accessHandler = accessHandler;
        return this;
    }

    public Hadrian builder() {
        Class<?> c;
        String factoryName;
        String kairosDbUrl;
        this.client = new OkHttpClient();
        this.client.setConnectTimeout(2L, TimeUnit.SECONDS);
        this.client.setReadTimeout(15L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(2L, TimeUnit.SECONDS);
        this.client.setFollowSslRedirects(false);
        this.client.setFollowRedirects(false);
        this.client.setConnectionPool(new ConnectionPool(5, 60000L));
        this.metricRegistry = new MetricRegistry.Builder("PST", "SDT").addTag("hostName", this.getHostname()).build();
        JvmMetrics.addMetrics(this.metricRegistry, 10);
        if (this.parameters.getBoolean("metrics.console", false)) {
            this.metricRegistry.addEventListener(new ConsoleListener(System.out));
        }
        if ((kairosDbUrl = this.parameters.getString("metrics.kairosDb.url", null)) != null && !kairosDbUrl.isEmpty()) {
            this.metricRegistry.addEventListener(new KairosDBListener(kairosDbUrl, this.parameters.getString("metrics.kairosDb.username", null), this.parameters.getString("metrics.kairosDb.password", null)));
        }
        if (this.dataAccess == null) {
            DataAccessFactory factory;
            factoryName = this.parameters.getString("dataAccess.factoryClassName", "com.northernwall.hadrian.db.inMemory.InMemoryDataAccessFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find DataAccess class " + factoryName);
            }
            try {
                factory = (DataAccessFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation DataAccess class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access DataAccess class " + factoryName);
            }
            this.dataAccess = factory.createDataAccess(this.parameters, this.metricRegistry);
        }
        if (this.moduleArtifactHelper == null && (factoryName = this.parameters.getString("module.artifact.FactoryClassName", "com.northernwall.hadrian.module.maven.MavenHelperFactory")) != null && !factoryName.isEmpty()) {
            ModuleArtifactHelperFactory moduleArtifactHelperFactory;
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find ModuleArtifactHelper class " + factoryName);
            }
            try {
                moduleArtifactHelperFactory = (ModuleArtifactHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation ModuleArtifactHelper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access ModuleArtifactHelper class " + factoryName);
            }
            this.moduleArtifactHelper = moduleArtifactHelperFactory.create(this.parameters, this.client);
        }
        if (this.moduleConfigHelper == null && (factoryName = this.parameters.getString("module.config.FactoryClassName", null)) != null && !factoryName.isEmpty()) {
            ModuleConfigHelperFactory moduleConfigHelperFactory;
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find ModuleConfigHelper class " + factoryName);
            }
            try {
                moduleConfigHelperFactory = (ModuleConfigHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation ModuleConfigHelper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access ModuleConfigHelper class " + factoryName);
            }
            this.moduleConfigHelper = moduleConfigHelperFactory.create(this.parameters, this.client);
        }
        this.configHelper = new ConfigHelper(this.parameters, this.moduleConfigHelper);
        this.accessHelper = new AccessHelper(this.dataAccess);
        if (this.accessHandler == null) {
            AccessHandlerFactory accessHanlderFactory;
            factoryName = this.parameters.getString("accessHandler.factoryClassName", "com.northernwall.hadrian.access.simple.SimpleAccessHandlerFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find Access class " + factoryName);
            }
            try {
                accessHanlderFactory = (AccessHandlerFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation Access class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access Access class " + factoryName);
            }
            this.accessHandler = accessHanlderFactory.create(this.accessHelper, this.parameters, this.metricRegistry);
        }
        if (this.hostDetailsHelper == null) {
            HostDetailsHelperFactory hostDetailsHelperFactory;
            factoryName = this.parameters.getString("hostDetailsHelper.factoryClassName", "com.northernwall.hadrian.details.simple.SimpleHostDetailsHelperFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find Host Details Helper class " + factoryName);
            }
            try {
                hostDetailsHelperFactory = (HostDetailsHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation Host Details Helper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access Host Details Helper class " + factoryName);
            }
            this.hostDetailsHelper = hostDetailsHelperFactory.create(this.client, this.parameters);
        }
        if (this.vipDetailsHelper == null && (factoryName = this.parameters.getString("vipDetailsHelper.factoryClassName", "com.northernwall.hadrian.details.simple.SimpleVipDetailsHelperFactory")) != null && !factoryName.isEmpty()) {
            VipDetailsHelperFactory vipDetailsHelperFactory;
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find VIP Details Helper class " + factoryName);
            }
            try {
                vipDetailsHelperFactory = (VipDetailsHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation VIP Details Helper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access VIP Details Helper class " + factoryName);
            }
            this.vipDetailsHelper = vipDetailsHelperFactory.create(this.client, this.parameters, this.configHelper);
        }
        if (this.calendarHelper == null) {
            CalendarHelperFactory calendarHelperFactory;
            factoryName = this.parameters.getString("calendarHelper.factoryClassName", "com.northernwall.hadrian.calendar.simple.SimpleCalendarHelperFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find Calendar Helper class " + factoryName);
            }
            try {
                calendarHelperFactory = (CalendarHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation Calendar Helper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access Calendar Helper class " + factoryName);
            }
            this.calendarHelper = calendarHelperFactory.create(this.parameters, this.client);
        }
        WorkItemProcessor workItemProcessor = new WorkItemProcessor(this.parameters, this.configHelper, this.dataAccess, this.client, new Gson(), this.metricRegistry);
        DataAccessUpdater.update(this.dataAccess, this.configHelper.getConfig());
        return new Hadrian(this.parameters, this.client, this.configHelper, this.dataAccess, this.moduleArtifactHelper, this.moduleConfigHelper, this.accessHelper, this.accessHandler, this.hostDetailsHelper, this.vipDetailsHelper, this.calendarHelper, workItemProcessor, this.metricRegistry);
    }

    private String getHostname() {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            int i = hostname.indexOf(".");
            if (i > 0) {
                hostname = hostname.substring(0, i);
            }
            LOGGER.info("Hostname is {}", (Object)hostname);
            return hostname;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find hostname", e);
        }
    }
}

