/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.email;

import com.codahale.metrics.MetricRegistry;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.WorkItemSender;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailWorkItemSender
extends WorkItemSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailWorkItemSender.class);
    private final String smtpHostname;
    private final int smtpPort;
    private final boolean smtpSsl;
    private final String smtpUsername;
    private final String smtpPassword;
    private final List<String> emailTos;
    private final String emailFrom;

    public EmailWorkItemSender(Parameters parameters, MetricRegistry metricRegistry) {
        super(parameters);
        this.smtpHostname = parameters.getString("emailWorkItem.smtp.hostname", null);
        this.smtpPort = parameters.getInt("emailWorkItem.smtp.port", 25);
        this.smtpSsl = parameters.getBoolean("emailWorkItem.smtp.ssl", false);
        this.smtpUsername = parameters.getString("emailWorkItem.smtp.username", null);
        this.smtpPassword = parameters.getString("emailWorkItem.smtp.password", null);
        String temp = parameters.getString("emailWorkItem.emailTo", null);
        this.emailTos = new LinkedList<String>();
        if (temp == null) {
            logger.warn("Property '{}' not set, so no emails will be sent", (Object)"emailWorkItem.emailTo");
        } else {
            String[] parts;
            for (String part : parts = temp.split(",")) {
                if (part == null || part.isEmpty()) continue;
                this.emailTos.add(part.trim());
            }
        }
        String fromDefault = null;
        if (!this.emailTos.isEmpty()) {
            fromDefault = this.emailTos.get(0);
        }
        this.emailFrom = parameters.getString("emailWorkItem.emailFrom", fromDefault);
    }

    @Override
    public void setWorkItemProcessor(WorkItemProcessor workItemProcessor) {
    }

    @Override
    public Result sendWorkItem(WorkItem workItem) {
        switch (workItem.getType()) {
            case module: {
                this.sendModuleEmail(workItem);
                break;
            }
            case host: {
                this.sendHostEmail(workItem);
                break;
            }
            case vip: {
                this.sendVipEmail(workItem);
                break;
            }
            case hostvip: {
                this.sendHostVipEmail(workItem);
                break;
            }
            default: {
                logger.warn("Unknown workItem type {} with operation {}", (Object)workItem.getType(), (Object)workItem.getOperation());
            }
        }
        return Result.wip;
    }

    protected void sendModuleEmail(WorkItem workItem) {
        logger.info("Processing Module {} on {} with opertion {}", new Object[]{workItem.getMainModule().moduleName, workItem.getService().serviceName, workItem.getOperation()});
        String subject = (Object)((Object)workItem.getOperation()) + " module " + workItem.getMainModule().moduleName;
        StringBuffer body = new StringBuffer();
        this.addEmailHeader(workItem, body);
        body.append("\n");
        this.addLine("Module Name", workItem.getMainModule().moduleName, body);
        this.addLine("Module Type", workItem.getMainModule().moduleType.toString(), body);
        body.append("\n");
        this.addLine("Git URL", this.getGitUrl(workItem), body);
        this.addLine("Git Folder", workItem.getMainModule().gitFolder, body);
        this.addLine("Maven Group", workItem.getMainModule().mavenGroupId, body);
        this.addLine("Maven Artifact ID", workItem.getMainModule().mavenArtifactId, body);
        this.addLine("Artifact Type", workItem.getMainModule().artifactType, body);
        this.addLine("Artifact Suffix", workItem.getMainModule().artifactSuffix, body);
        this.emailWorkItem(subject, body.toString());
    }

    protected void sendHostEmail(WorkItem workItem) {
        logger.info("Processing Host {} on {} with opertion {}", new Object[]{workItem.getHost().hostName, workItem.getService().serviceName, workItem.getOperation()});
        String subject = (Object)((Object)workItem.getOperation()) + " host " + workItem.getHost().hostName;
        StringBuffer body = new StringBuffer();
        this.addEmailHeader(workItem, body);
        body.append("\n");
        this.addLine("Host Name", workItem.getHost().hostName, body);
        this.addLine("Data Center", workItem.getHost().dataCenter, body);
        this.addLine("Network", workItem.getHost().network, body);
        this.addLine("Environment", workItem.getHost().env, body);
        this.addLine("Size", workItem.getHost().size, body);
        this.addLine("Version", workItem.getHost().version, body);
        this.emailWorkItem(subject, body.toString());
    }

    protected void sendVipEmail(WorkItem workItem) {
        logger.info("Processing Vip {} on {} with opertion {}", new Object[]{workItem.getVip().vipName, workItem.getService().serviceName, workItem.getOperation()});
        String subject = (Object)((Object)workItem.getOperation()) + " vip " + workItem.getVip().vipName;
        StringBuffer body = new StringBuffer();
        this.addEmailHeader(workItem, body);
        body.append("\n");
        this.addLine("VIP Name", workItem.getVip().vipName, body);
        this.addLine("DNS", workItem.getVip().dns + "." + workItem.getVip().domain, body);
        this.addLine("Network", workItem.getVip().network, body);
        this.addLine("Public", Boolean.toString(workItem.getVip().external), body);
        this.addLine("Protocol", workItem.getVip().protocol, body);
        this.addLine("VIP Port", Integer.toString(workItem.getVip().vipPort), body);
        this.addLine("Service Port", Integer.toString(workItem.getVip().servicePort), body);
        this.emailWorkItem(subject, body.toString());
    }

    protected void sendHostVipEmail(WorkItem workItem) {
        String subject;
        logger.info("Processing Host Vip {} {} on {} with opertion {}", new Object[]{workItem.getHost().hostName, workItem.getVip().vipName, workItem.getService().serviceName, workItem.getOperation()});
        switch (workItem.getOperation()) {
            case create: {
                subject = "Add Host to Vip";
                break;
            }
            case delete: {
                subject = "Remove Host from Vip";
                break;
            }
            default: {
                logger.warn("Unknown workItem operation {} for host {}", (Object)workItem.getOperation(), (Object)workItem.getHost().hostName);
                return;
            }
        }
        StringBuffer body = new StringBuffer();
        this.addEmailHeader(workItem, body);
        body.append("\n");
        this.addLine("Host Name", workItem.getHost().hostName, body);
        this.addLine("Data Center", workItem.getHost().dataCenter, body);
        this.addLine("Network", workItem.getHost().network, body);
        body.append("\n");
        this.addLine("VIP Name", workItem.getVip().vipName, body);
        this.addLine("DNS", workItem.getVip().dns + "." + workItem.getVip().domain, body);
        this.emailWorkItem(subject, body.toString());
    }

    private void addEmailHeader(WorkItem workItem, StringBuffer body) {
        this.addLine("Type", workItem.getType().toString(), body);
        this.addLine("Operation", workItem.getOperation().toString(), body);
        this.addLine("Requestor", workItem.getUsername(), workItem.getFullname(), body);
        this.addLine("Team", workItem.getTeam().teamName, body);
        body.append("\n");
        this.addLine("Service Abbr", workItem.getService().serviceAbbr, workItem.getService().serviceName, body);
    }

    private void addLine(String label, String value, StringBuffer body) {
        body.append(label);
        body.append(": ");
        body.append(value);
        body.append("\n");
    }

    private void addLine(String label, String shortValue, String longValue, StringBuffer body) {
        body.append(label);
        body.append(": (");
        body.append(shortValue);
        body.append(") ");
        body.append(longValue);
        body.append("\n");
    }

    private void emailWorkItem(String subject, String body) {
        try {
            if (this.emailTos.isEmpty()) {
                return;
            }
            SimpleEmail email = new SimpleEmail();
            if (this.smtpHostname != null) {
                email.setHostName(this.smtpHostname);
            }
            email.setSmtpPort(this.smtpPort);
            if (this.smtpUsername != null && this.smtpPassword != null) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.smtpUsername, this.smtpPassword));
            }
            email.setSSLOnConnect(this.smtpSsl);
            email.setFrom(this.emailFrom);
            email.setSubject(subject);
            email.setMsg(body);
            for (String emailTo : this.emailTos) {
                email.addTo(emailTo);
            }
            email.send();
            if (this.emailTos.size() == 1) {
                logger.info("Emailing work item to {} with subject {}", (Object)this.emailTos.get(0), (Object)subject);
            } else {
                logger.info("Emailing work item to {} and {} other email addresses with subject {}", new Object[]{this.emailTos.get(0), this.emailTos.size() - 1, subject});
            }
        }
        catch (EmailException ex) {
            throw new RuntimeException("Failure emailing work item, {}", ex);
        }
    }
}

