/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.WorkItemSender;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemProcessor.class);
    private final DataAccess dataAccess;
    private final WorkItemSender workItemSender;
    private final Timer timerProcess;
    private final Timer timerCalback;
    private final Meter meterSuccess;
    private final Meter meterFail;
    private final Gson gson;

    public WorkItemProcessor(DataAccess dataAccess, WorkItemSender workItemSender, MetricRegistry metricRegistry) {
        this.dataAccess = dataAccess;
        this.workItemSender = workItemSender;
        this.timerProcess = metricRegistry.timer("workItem.sendWorkItem");
        this.timerCalback = metricRegistry.timer("workItem.callback.process");
        this.meterSuccess = metricRegistry.meter("workItem.callback.success");
        this.meterFail = metricRegistry.meter("workItem.callback.fail");
        this.gson = new Gson();
    }

    public WorkItemSender getWorkItemSender() {
        return this.workItemSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWorkItem(WorkItem workItem) throws IOException {
        Result result;
        Timer.Context context = this.timerProcess.time();
        try {
            result = this.workItemSender.sendWorkItem(workItem);
        }
        finally {
            context.stop();
        }
        switch (result) {
            case success: {
                logger.info("Work item sender says work item  {} has been process, no callback expected.", (Object)workItem.getId());
                break;
            }
            case error: {
                logger.warn("Work item sender says work item  {} failed to be process, no callback expected.", (Object)workItem.getId());
                break;
            }
            case wip: {
                logger.info("Work item sender says work item  {} is being processed.", (Object)workItem.getId());
                return;
            }
        }
        CallbackData callbackData = new CallbackData();
        callbackData.requestId = workItem.getId();
        callbackData.errorCode = 0;
        callbackData.errorDescription = " ";
        callbackData.status = result;
        callbackData.output = null;
        this.processCallback(callbackData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCallback(CallbackData callbackData) throws IOException {
        Timer.Context context = this.timerCalback.time();
        try {
            WorkItem workItem = this.dataAccess.getWorkItem(callbackData.requestId);
            if (workItem == null) {
                throw new RuntimeException("Could not find work item " + callbackData.requestId);
            }
            if (callbackData.status == null) {
                throw new RuntimeException("Callback is missing status, " + callbackData.requestId);
            }
            this.dataAccess.deleteWorkItem(callbackData.requestId);
            switch (callbackData.status) {
                case success: {
                    this.meterSuccess.mark();
                    break;
                }
                case error: {
                    this.meterFail.mark();
                    break;
                }
                case wip: {
                    logger.warn("ProcessCallback should never be called for WIP");
                    return;
                }
            }
            HashMap<String, String> notes = new HashMap<String, String>();
            block7 : switch (workItem.getType()) {
                case module: {
                    switch (workItem.getOperation()) {
                        case create: {
                            notes.put("template", workItem.getMainModule().template);
                            notes.put("type", workItem.getMainModule().moduleType.toString());
                            break block7;
                        }
                        case update: {
                            break block7;
                        }
                        case delete: {
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                case host: {
                    switch (workItem.getOperation()) {
                        case create: {
                            this.createHost(workItem, callbackData.status);
                            notes.put("env", workItem.getHost().env);
                            notes.put("size", workItem.getHost().size);
                            notes.put("reason", workItem.getHost().reason);
                            break block7;
                        }
                        case deploy: {
                            this.deploySoftware(workItem, callbackData.status);
                            if (workItem.getHost().version != null) {
                                notes.put("version", workItem.getHost().version);
                            }
                            if (workItem.getHost().versionUrl != null) {
                                notes.put("versionUrl", workItem.getHost().versionUrl);
                            }
                            notes.put("reason", workItem.getHost().reason);
                            break block7;
                        }
                        case restart: {
                            this.restartHost(workItem, callbackData.status);
                            notes.put("reason", workItem.getHost().reason);
                            break block7;
                        }
                        case delete: {
                            this.deleteHost(workItem, callbackData.status);
                            notes.put("reason", workItem.getHost().reason);
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                case vip: {
                    switch (workItem.getOperation()) {
                        case create: {
                            notes.put("protocol", workItem.getVip().protocol);
                            notes.put("vip_port", Integer.toString(workItem.getVip().vipPort));
                            notes.put("service_port", Integer.toString(workItem.getVip().servicePort));
                            notes.put("external", Boolean.toString(workItem.getVip().external));
                            this.createVip(workItem, callbackData.status);
                            break block7;
                        }
                        case update: {
                            notes.put("protocol", workItem.getVip().protocol);
                            notes.put("vip_port", Integer.toString(workItem.getVip().vipPort));
                            notes.put("service_port", Integer.toString(workItem.getVip().servicePort));
                            notes.put("external", Boolean.toString(workItem.getVip().external));
                            this.updateVip(workItem, callbackData.status);
                            break block7;
                        }
                        case delete: {
                            this.deleteVip(workItem, callbackData.status);
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                case hostvip: {
                    switch (workItem.getOperation()) {
                        case create: {
                            this.addHostVip(workItem, callbackData.status);
                            break block7;
                        }
                        case delete: {
                            this.deleteHostVip(workItem, callbackData.status);
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                default: {
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
            }
            if (callbackData.status == Result.success) {
                Audit audit = new Audit();
                audit.serviceId = workItem.getService().serviceId;
                audit.timePerformed = this.getGmt();
                audit.timeRequested = workItem.getRequestDate();
                audit.requestor = workItem.getUsername();
                audit.type = workItem.getType();
                audit.operation = workItem.getOperation();
                if (workItem.getMainModule() != null) {
                    audit.moduleName = workItem.getMainModule().moduleName;
                }
                if (workItem.getHost() != null) {
                    audit.hostName = workItem.getHost().hostName;
                }
                if (workItem.getVip() != null) {
                    audit.vipName = workItem.getVip().vipName;
                }
                audit.notes = notes.isEmpty() ? "" : this.gson.toJson(notes);
                this.dataAccess.saveAudit(audit, callbackData.output);
            } else {
                this.deleteNextWorkItem(workItem.getNextId());
            }
        }
        finally {
            context.stop();
        }
    }

    private Date getGmt() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
    }

    private void deleteNextWorkItem(String nextId) {
        if (nextId != null) {
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
            this.deleteNextWorkItem(nextWorkItem.getNextId());
            WorkItem workItem = this.dataAccess.getWorkItem(nextId);
            if (workItem != null) {
                Host host;
                if (workItem.getType() == Type.host && (host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId)) != null) {
                    host.setStatus("-");
                    this.dataAccess.updateHost(host);
                }
                this.dataAccess.deleteWorkItem(nextId);
            }
        }
    }

    private void createHost(WorkItem workItem, Result result) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        if (result == Result.success) {
            if (workItem.getNextId() != null) {
                WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
                if (nextWorkItem != null) {
                    host.setStatus("Deploying...");
                    this.dataAccess.updateHost(host);
                    this.sendWorkItem(nextWorkItem);
                } else {
                    logger.warn("Odd, the deploy work item {} for create host {} could not be found", (Object)workItem.getNextId(), (Object)host.getHostName());
                    host.setStatus("-");
                    this.dataAccess.updateHost(host);
                }
            } else {
                logger.warn("Odd, create host {} work item has no deploy work item id", (Object)host.getHostName());
            }
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)host.getHostId(), (Object)result);
            this.dataAccess.deleteHost(host.getServiceId(), host.getHostId());
        }
    }

    private void deploySoftware(WorkItem workItem, Result result) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being updated", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus("-");
        this.dataAccess.updateHost(host);
        if (result == Result.success) {
            if (workItem.getNextId() == null) {
                return;
            }
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
            Host nextHost = this.dataAccess.getHost(nextWorkItem.getService().serviceId, nextWorkItem.getHost().hostId);
            if (nextHost == null) {
                logger.error("Finished updating {}, next work item is {}, but could not find it.", (Object)workItem.getHost().hostId, (Object)nextWorkItem.getHost().hostId);
                return;
            }
            nextHost.setStatus("Deploying...");
            this.dataAccess.saveHost(nextHost);
            this.sendWorkItem(nextWorkItem);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getHost().hostId, (Object)result);
        }
    }

    private void restartHost(WorkItem workItem, Result result) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        if (result == Result.success) {
            host.setStatus("-");
            this.dataAccess.updateHost(host);
            if (workItem.getNextId() == null) {
                return;
            }
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
            Host nextHost = this.dataAccess.getHost(nextWorkItem.getService().serviceId, nextWorkItem.getHost().hostId);
            if (nextHost == null) {
                logger.error("Finished restarting {}, next work item is {}, but could not find it.", (Object)workItem.getHost().hostId, (Object)nextWorkItem.getHost().hostId);
                return;
            }
            nextHost.setStatus("Restarting...");
            this.dataAccess.saveHost(nextHost);
            this.sendWorkItem(nextWorkItem);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getHost().hostId, (Object)result);
        }
    }

    private void deleteHost(WorkItem workItem, Result result) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} to delete.", (Object)workItem.getHost().hostId);
            return;
        }
        if (result == Result.success) {
            this.dataAccess.deleteHost(host.getServiceId(), host.getHostId());
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)host.getHostId(), (Object)result);
            host.setStatus("-");
            this.dataAccess.updateHost(host);
        }
    }

    private void createVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being created", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)result);
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        }
    }

    private void updateVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being updated", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            vip.setStatus("-");
            vip.setExternal(workItem.getVip().external);
            vip.setServicePort(workItem.getVip().servicePort);
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getVip().vipId, (Object)result);
        }
    }

    private void deleteVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.error("Could not find end point {} to delete.", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            this.dataAccess.deleteVipRefs(vip.getVipId());
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)result);
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        }
    }

    private void addHostVip(WorkItem workItem, Result result) {
        VipRef vipRef = this.dataAccess.getVipRef(workItem.getHost().hostId, workItem.getVip().vipId);
        if (vipRef == null) {
            logger.error("Could not find end point ref {} {} to create.", (Object)workItem.getHost().hostId, (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            vipRef.setStatus("-");
            this.dataAccess.updateVipRef(vipRef);
        } else {
            logger.warn("Callback for {} {} failed with status {}", new Object[]{vipRef.getHostId(), vipRef.getVipId(), result.toString()});
            this.dataAccess.deleteVipRef(vipRef.getHostId(), vipRef.getVipId());
        }
    }

    private void deleteHostVip(WorkItem workItem, Result result) {
        VipRef vipRef = this.dataAccess.getVipRef(workItem.getHost().hostId, workItem.getVip().vipId);
        if (vipRef == null) {
            logger.error("Could not find end point ref {} {} to delete.", (Object)workItem.getHost().hostId, (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            this.dataAccess.deleteVipRef(vipRef.getHostId(), vipRef.getVipId());
        } else {
            logger.warn("Callback for {} {} failed with status {}", new Object[]{vipRef.getHostId(), vipRef.getVipId(), result.toString()});
            vipRef.setStatus("-");
            this.dataAccess.updateVipRef(vipRef);
        }
    }
}

