/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.utilityHandlers;

import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.WorkItemSender;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(HealthHandler.class);
    private final Handler accessHandler;
    private final CalendarHelper calendarHelper;
    private final DataAccess dataAccess;
    private final MavenHelper mavenHelper;
    private final Parameters parameters;
    private final WorkItemSender workItemSender;
    private final String version;

    public HealthHandler(Handler accessHandler, CalendarHelper calendarHelper, DataAccess dataAccess, MavenHelper mavenHelper, Parameters parameters, WorkItemSender workItemSender) {
        this.accessHandler = accessHandler;
        this.calendarHelper = calendarHelper;
        this.dataAccess = dataAccess;
        this.mavenHelper = mavenHelper;
        this.parameters = parameters;
        this.workItemSender = workItemSender;
        String temp = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        this.version = temp == null ? "unknown" : temp;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setStatus(200);
        this.showHealth(response);
        request.setHandled(true);
    }

    private void showHealth(HttpServletResponse response) throws IOException {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        this.writeln(response, "<html>");
        this.writeln(response, "<body>");
        this.writeln(response, "<table>");
        this.writeln(response, "Version", this.version);
        this.writeln(response, "JVM Name", runtimeMXBean.getSpecName());
        this.writeln(response, "JVM Version", runtimeMXBean.getSpecVersion());
        this.writeln(response, "JVM Vendor", runtimeMXBean.getSpecVendor());
        this.writeln(response, "JVM Threads", threadMXBean.getThreadCount());
        this.writeln(response, "JVM Peak Threads", threadMXBean.getPeakThreadCount());
        this.writeln(response, "Current Time", new Date());
        this.writeln(response, "Start Time", new Date(runtimeMXBean.getStartTime()));
        this.writeln(response, "Class - Access Handler", this.accessHandler.getClass().getCanonicalName());
        this.writeln(response, "Class - Calendar Helper", this.calendarHelper.getClass().getCanonicalName());
        this.writeln(response, "Class - Data Access", this.dataAccess.getClass().getCanonicalName());
        this.writeln(response, "Class - Maven Helper", this.mavenHelper.getClass().getCanonicalName());
        this.writeln(response, "Class - Parameters", this.parameters.getClass().getCanonicalName());
        this.writeln(response, "Class - Work Item Sender", this.workItemSender.getClass().getCanonicalName());
        Map<String, String> healthMap = this.dataAccess.getHealth();
        TreeSet<String> keys = new TreeSet<String>(healthMap.keySet());
        for (String key : keys) {
            this.writeln(response, key, healthMap.get(key));
        }
        this.writeln(response, "</table>");
        this.writeln(response, "</body>");
        this.writeln(response, "</html>");
    }

    private void writeln(HttpServletResponse response, String text) throws IOException {
        response.getOutputStream().write(text.getBytes());
    }

    private void writeln(HttpServletResponse response, String label, Date value) throws IOException {
        this.writeln(response, label, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value));
    }

    private void writeln(HttpServletResponse response, String label, int value) throws IOException {
        this.writeln(response, label, Integer.toString(value));
    }

    private void writeln(HttpServletResponse response, String label, String value) throws IOException {
        String text = "<tr><td>" + label + "</td><td>" + value + "</td></tr>";
        response.getOutputStream().write(text.getBytes());
    }
}

