/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.tree;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.tree.dao.TreeNode;
import com.northernwall.hadrian.tree.dao.TreeNodeData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class TreeHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final Gson gson;

    public TreeHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        User user = (User)request.getAttribute("user");
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            jw.beginArray();
            this.listDevTeams(jw);
            this.listGraph(jw);
            if (user.isOps()) {
                this.listOpsTeam(jw);
            }
            if (user.isAdmin()) {
                this.listAdminTeam(jw);
            }
            this.listHelp(jw);
            jw.endArray();
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void listDevTeams(JsonWriter jw) throws JsonIOException {
        TreeNode devTeamsTreenode = new TreeNode();
        devTeamsTreenode.setLabel("Dev Teams");
        devTeamsTreenode.setData(new TreeNodeData("-1", "DevTeams"));
        List<Team> teams = this.dataAccess.getTeams();
        Collections.sort(teams);
        for (Team team : teams) {
            TreeNode teamTreenode = new TreeNode();
            teamTreenode.setLabel(team.getTeamName());
            teamTreenode.setData(new TreeNodeData(team.getTeamId(), "Team"));
            List<Service> services = this.dataAccess.getServices(team.getTeamId());
            Collections.sort(services);
            for (Service service : services) {
                TreeNode serviceTreeNode = new TreeNode();
                serviceTreeNode.setLabel(service.getServiceName());
                serviceTreeNode.setData(new TreeNodeData(service.getServiceId(), "Service"));
                teamTreenode.getChildren().add(serviceTreeNode);
            }
            devTeamsTreenode.getChildren().add(teamTreenode);
        }
        this.gson.toJson((Object)devTeamsTreenode, TreeNode.class, jw);
    }

    private void listGraph(JsonWriter jw) throws JsonIOException {
        TreeNode graphTreenode = new TreeNode();
        graphTreenode.setLabel("Graph");
        graphTreenode.setData(new TreeNodeData("-2", "Graph"));
        this.gson.toJson((Object)graphTreenode, TreeNode.class, jw);
    }

    private void listOpsTeam(JsonWriter jw) throws JsonIOException {
        TreeNode opsTeamTreenode = new TreeNode();
        opsTeamTreenode.setLabel("Ops Team");
        opsTeamTreenode.setData(new TreeNodeData("-4", "OpsTeam"));
        TreeNode tasksTreenode = new TreeNode();
        tasksTreenode.setLabel("Cross Service");
        tasksTreenode.setData(new TreeNodeData("-5", "CrossService"));
        opsTeamTreenode.getChildren().add(tasksTreenode);
        TreeNode webhooksTreenode = new TreeNode();
        webhooksTreenode.setLabel("Work Items");
        webhooksTreenode.setData(new TreeNodeData("-6", "WorkItems"));
        opsTeamTreenode.getChildren().add(webhooksTreenode);
        TreeNode backfillTreenode = new TreeNode();
        backfillTreenode.setLabel("Backfill");
        backfillTreenode.setData(new TreeNodeData("-7", "Backfill"));
        opsTeamTreenode.getChildren().add(backfillTreenode);
        TreeNode optionsTreenode = new TreeNode();
        optionsTreenode.setLabel("Parameters");
        optionsTreenode.setData(new TreeNodeData("-8", "Parameters"));
        opsTeamTreenode.getChildren().add(optionsTreenode);
        this.gson.toJson((Object)opsTeamTreenode, TreeNode.class, jw);
    }

    private void listAdminTeam(JsonWriter jw) throws JsonIOException {
        TreeNode adminTreenode = new TreeNode();
        adminTreenode.setLabel("Admin");
        adminTreenode.setData(new TreeNodeData("-9", "Admin"));
        this.gson.toJson((Object)adminTreenode, TreeNode.class, jw);
    }

    private void listHelp(JsonWriter jw) throws JsonIOException {
        TreeNode adminTreenode = new TreeNode();
        adminTreenode.setLabel("Help");
        adminTreenode.setData(new TreeNodeData("-10", "Help"));
        this.gson.toJson((Object)adminTreenode, TreeNode.class, jw);
    }
}

