/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.service.dao.GetHostDetailsData;
import com.northernwall.hadrian.service.dao.GetPairData;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDetailsHelper
implements ParameterChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(HostDetailsHelper.class);
    private final OkHttpClient client;
    private final Parameters parameters;
    private final JsonParser parser;
    private List<String> urlTemplates;
    private final List<String> attributes;

    public HostDetailsHelper(OkHttpClient client, Parameters parameters) {
        this.client = client;
        this.parameters = parameters;
        this.parser = new JsonParser();
        this.urlTemplates = new LinkedList<String>();
        this.attributes = new LinkedList<String>();
        this.load();
        parameters.registerChangeListener(this);
    }

    @Override
    public void onChange(List<String> keys) {
        this.load();
    }

    private void load() {
        String[] parts;
        String temp = this.parameters.getString("host.detailsUrl", null);
        this.urlTemplates.clear();
        if (temp != null && !temp.isEmpty()) {
            for (String part : parts = temp.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                this.urlTemplates.add(part);
            }
        }
        temp = this.parameters.getString("host.detailsAttrs", null);
        this.attributes.clear();
        if (temp != null && !temp.isEmpty()) {
            for (String part : parts = temp.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                this.attributes.add(part);
            }
        }
    }

    public GetHostDetailsData getDetails(Host host) {
        LinkedList<GetPairData> data = new LinkedList<GetPairData>();
        data.add(new GetPairData("host id", host.getHostId()));
        if (!this.urlTemplates.isEmpty()) {
            for (String urlTemplate : this.urlTemplates) {
                String url = urlTemplate.replace("{host}", host.getHostName());
                this.getDetailsFromUrl(host, url, data);
            }
        }
        Collections.sort(data);
        GetHostDetailsData details = new GetHostDetailsData();
        for (GetPairData pair : data) {
            if (details.left.size() == details.right.size()) {
                details.left.add(pair);
                continue;
            }
            details.right.add(pair);
        }
        return details;
    }

    private void getDetailsFromUrl(Host host, String url, List<GetPairData> data) {
        Request httpRequest = new Request.Builder().url(url).build();
        try {
            InputStreamReader reader;
            JsonElement jsonElement;
            Response resp = this.client.newCall(httpRequest).execute();
            if (resp.isSuccessful() && (jsonElement = this.parser.parse((Reader)(reader = new InputStreamReader(resp.body().byteStream())))).isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        this.addPair((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString(), data);
                        continue;
                    }
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    StringBuffer buffer = null;
                    JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonElement arrayElement = jsonArray.get(i);
                        if (!arrayElement.isJsonPrimitive()) continue;
                        if (buffer == null) {
                            buffer = new StringBuffer(arrayElement.getAsString());
                            continue;
                        }
                        buffer.append(", ");
                        buffer.append(arrayElement.getAsString());
                    }
                    if (buffer == null) continue;
                    this.addPair((String)entry.getKey(), buffer.toString(), data);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Error while getting secondary host details for {}, error {}", (Object)host.getHostName(), (Object)ex.getMessage());
        }
    }

    private void addPair(String label, String value, List<GetPairData> data) {
        if (label == null || label.isEmpty() || value == null || value.isEmpty()) {
            return;
        }
        if (this.attributes.isEmpty() || this.attributes.contains(label)) {
            label = label.replace("-", " ").replace("_", " ");
            data.add(new GetPairData(label, value));
        }
    }
}

