/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.dao;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.dao.GetServiceData;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GetTeamData {
    public String teamId;
    public String teamName;
    public String teamEmail;
    public String teamIrc;
    public String gitGroup;
    public String calendarId;
    public List<User> users;
    public List<GetServiceData> services;
    public boolean canModify;

    public static GetTeamData create(Team team, DataAccess dataAccess) {
        GetTeamData temp = new GetTeamData();
        temp.teamId = team.getTeamId();
        temp.teamName = team.getTeamName();
        temp.teamEmail = team.getTeamEmail();
        temp.teamIrc = team.getTeamIrc();
        temp.gitGroup = team.getGitGroup();
        temp.calendarId = team.getCalendarId();
        temp.users = new LinkedList<User>();
        for (String username : team.getUsernames()) {
            temp.users.add(dataAccess.getUser(username));
        }
        Collections.sort(temp.users);
        temp.services = new LinkedList<GetServiceData>();
        for (Service service : dataAccess.getServices(team.getTeamId())) {
            temp.services.add(GetServiceData.create(service));
        }
        for (Service service : dataAccess.getDeletedServices(team.getTeamId())) {
            temp.services.add(GetServiceData.create(service));
        }
        return temp;
    }
}

