/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.dao;

import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.service.dao.GetHostData;
import com.northernwall.hadrian.service.dao.GetModuleNetworkData;
import com.northernwall.hadrian.service.dao.GetVipData;
import java.util.LinkedList;
import java.util.List;

public class GetModuleData {
    public String moduleId;
    public String moduleName;
    public int order;
    public ModuleType moduleType;
    public String gitProject;
    public String gitFolder;
    public String mavenGroupId;
    public String mavenArtifactId;
    public String artifactType;
    public String artifactSuffix;
    public String hostAbbr;
    public String versionUrl;
    public String availabilityUrl;
    public String runAs;
    public String deploymentFolder;
    public String startCmdLine;
    public int startTimeOut;
    public String stopCmdLine;
    public int stopTimeOut;
    public List<String> versions;
    public List<GetModuleNetworkData> networks;
    public List<GetCustomFunctionData> customFunctions;

    public static GetModuleData create(Module module, Config config) {
        GetModuleData temp = new GetModuleData();
        temp.moduleId = module.getModuleId();
        temp.moduleName = module.getModuleName();
        temp.order = module.getOrder();
        temp.moduleType = module.getModuleType();
        temp.gitProject = module.getGitProject();
        temp.gitFolder = module.getGitFolder();
        temp.mavenGroupId = module.getMavenGroupId();
        temp.mavenArtifactId = module.getMavenArtifactId();
        temp.artifactType = module.getArtifactType();
        temp.artifactSuffix = module.getArtifactSuffix();
        temp.hostAbbr = module.getHostAbbr();
        temp.versionUrl = module.getVersionUrl();
        temp.availabilityUrl = module.getAvailabilityUrl();
        temp.runAs = module.getRunAs();
        temp.deploymentFolder = module.getDeploymentFolder();
        temp.startCmdLine = module.getStartCmdLine();
        temp.startTimeOut = module.getStartTimeOut();
        temp.stopCmdLine = module.getStopCmdLine();
        temp.stopTimeOut = module.getStopTimeOut();
        temp.versions = new LinkedList<String>();
        temp.networks = new LinkedList<GetModuleNetworkData>();
        for (String network : config.networkNames) {
            temp.networks.add(new GetModuleNetworkData(network));
        }
        temp.customFunctions = new LinkedList<GetCustomFunctionData>();
        return temp;
    }

    public void addHost(GetHostData hostData) {
        for (GetModuleNetworkData getModuleNetworkData : this.networks) {
            if (!getModuleNetworkData.network.equals(hostData.network)) continue;
            getModuleNetworkData.hosts.add(hostData);
            return;
        }
    }

    public void addVip(GetVipData vipData) {
        for (GetModuleNetworkData getModuleNetworkData : this.networks) {
            if (!getModuleNetworkData.network.equals(vipData.network)) continue;
            getModuleNetworkData.vips.add(vipData);
            return;
        }
    }

    public List<GetVipData> getVips(String network) {
        for (GetModuleNetworkData getModuleNetworkData : this.networks) {
            if (!getModuleNetworkData.network.equals(network)) continue;
            return getModuleNetworkData.vips;
        }
        return new LinkedList<GetVipData>();
    }

    public void addCustomFunction(GetCustomFunctionData customFunctionData) {
        this.customFunctions.add(customFunctionData);
    }
}

