/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http400BadRequestException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class UserModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public UserModifyHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        this.accessHelper.checkIfUserIsAdmin(request, "update user");
        User temp = this.fromJson(request, User.class);
        if (temp.getUsername() == null || temp.getUsername().isEmpty()) {
            throw new Http400BadRequestException("User Name is mising or empty");
        }
        if (temp.getFullName() == null) {
            throw new Http400BadRequestException("Full Name is mising or empty");
        }
        temp.setFullName(temp.getFullName().trim());
        if (temp.getFullName().isEmpty()) {
            throw new Http400BadRequestException("Full Name is mising or empty");
        }
        if (temp.getFullName().length() > 30) {
            throw new Http400BadRequestException("Full Name is to long, max is 30");
        }
        this.getDataAccess().updateUser(temp);
        response.setStatus(200);
        request.setHandled(true);
    }
}

