/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.PutTeamData;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http405NotAllowedException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class TeamModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public TeamModifyHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutTeamData data = this.fromJson(request, PutTeamData.class);
        Team team = this.getTeam(data.teamId, null);
        this.accessHelper.checkIfUserCanModify(request, data.teamId, "update team");
        data.teamName = data.teamName.trim();
        if (data.teamName.isEmpty()) {
            throw new Http400BadRequestException("Team Name is mising or empty");
        }
        if (data.teamName.length() > 30) {
            throw new Http400BadRequestException("Team Name is to long, max is 30");
        }
        if (data.gitGroup == null || data.gitGroup.isEmpty()) {
            throw new Http400BadRequestException("Git Group is mising or empty");
        }
        if (data.gitGroup.length() > 30) {
            throw new Http400BadRequestException("Git Group is to long, max is 30");
        }
        for (Team temp : this.getDataAccess().getTeams()) {
            if (temp.getTeamId().equals(data.teamId)) continue;
            if (temp.getTeamName().equals(data.teamName)) {
                throw new Http405NotAllowedException("Can not chnage team name, as a team with name " + data.teamName + " already exists");
            }
            if (!temp.getGitGroup().equals(data.gitGroup)) continue;
            throw new Http405NotAllowedException("Can not chnage team name, as a team with name " + data.teamName + " already exists");
        }
        team.setTeamName(data.teamName);
        team.setTeamEmail(data.teamEmail);
        team.setTeamIrc(data.teamIrc);
        team.setGitGroup(data.gitGroup);
        team.setCalendarId(data.calendarId);
        this.getDataAccess().saveTeam(team);
        response.setStatus(200);
        request.setHandled(true);
    }
}

