/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.DeleteServiceRefData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceRefDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceRefDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteServiceRefData deleteServiceRefData = this.fromJson(request, DeleteServiceRefData.class);
        Service clientService = this.getService(deleteServiceRefData.clientId, null, null);
        Service serverService = this.getService(deleteServiceRefData.serverId, null, null);
        User user = this.accessHelper.checkIfUserCanModify(request, clientService.getTeamId(), "delete a service ref");
        this.getDataAccess().deleteServiceRef(deleteServiceRefData.clientId, deleteServiceRefData.serverId);
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("uses", serverService.getServiceAbbr());
        this.createAudit(deleteServiceRefData.clientId, user.getUsername(), notes);
        notes = new HashMap();
        notes.put("use_by", clientService.getServiceAbbr());
        this.createAudit(deleteServiceRefData.serverId, user.getUsername(), notes);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String requestor, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.timePerformed = this.getGmt();
        audit.timeRequested = this.getGmt();
        audit.requestor = requestor;
        audit.type = Type.serviceRef;
        audit.operation = Operation.delete;
        audit.notes = ServiceRefDeleteHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

