/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.PostServiceRefData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceRefCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceRefCreateHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostServiceRefData postServiceRefData = this.fromJson(request, PostServiceRefData.class);
        Service clientService = this.getService(postServiceRefData.clientId, null, null);
        User user = this.accessHelper.checkIfUserCanModify(request, clientService.getTeamId(), "add a service ref");
        for (Map.Entry<String, String> entry : postServiceRefData.uses.entrySet()) {
            String serverId;
            Service serverService;
            if (!entry.getValue().equalsIgnoreCase("true") || (serverService = this.getService(serverId = entry.getKey(), null, null)) == null) continue;
            ServiceRef ref = new ServiceRef(postServiceRefData.clientId, serverId);
            this.getDataAccess().saveServiceRef(ref);
            HashMap<String, String> notes = new HashMap<String, String>();
            notes.put("uses", serverService.getServiceAbbr());
            this.createAudit(postServiceRefData.clientId, user.getUsername(), notes);
            notes = new HashMap();
            notes.put("use_by", clientService.getServiceAbbr());
            this.createAudit(serverId, user.getUsername(), notes);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String requestor, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.timePerformed = this.getGmt();
        audit.timeRequested = this.getGmt();
        audit.requestor = requestor;
        audit.type = Type.serviceRef;
        audit.operation = Operation.create;
        audit.notes = ServiceRefCreateHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

