/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.service.dao.GetNotUsesData;
import com.northernwall.hadrian.service.dao.GetServiceRefData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ServiceNotUsesGetHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final Gson gson;

    public ServiceNotUsesGetHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String id = request.getParameter("serviceId");
        List<Service> services = this.dataAccess.getServices();
        List<ServiceRef> refs = this.dataAccess.getServiceRefsByClient(id);
        GetNotUsesData notUses = new GetNotUsesData();
        for (Service service : services) {
            if (service.getServiceId().equals(id) || !service.getServiceType().equals("Service")) continue;
            boolean found = false;
            for (ServiceRef ref : refs) {
                if (!service.getServiceId().equals(ref.getServerServiceId())) continue;
                found = true;
            }
            if (found) continue;
            GetServiceRefData ref = new GetServiceRefData();
            ref.clientServiceId = id;
            ref.serverServiceId = service.getServiceId();
            ref.serviceName = service.getServiceName();
            notUses.refs.add(ref);
        }
        Collections.sort(notUses.refs, new Comparator<GetServiceRefData>(){

            @Override
            public int compare(GetServiceRefData o1, GetServiceRefData o2) {
                return o1.serviceName.compareTo(o2.serviceName);
            }
        });
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)notUses, GetNotUsesData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

