/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.service.dao.GetDataStoreData;
import com.northernwall.hadrian.service.dao.GetHostData;
import com.northernwall.hadrian.service.dao.GetModuleData;
import com.northernwall.hadrian.service.dao.GetServiceData;
import com.northernwall.hadrian.service.dao.GetServiceRefData;
import com.northernwall.hadrian.service.dao.GetVipData;
import com.northernwall.hadrian.service.dao.GetVipRefData;
import com.northernwall.hadrian.service.helper.InfoHelper;
import com.northernwall.hadrian.service.helper.ReadAvailabilityRunnable;
import com.northernwall.hadrian.service.helper.ReadMavenVersionsRunnable;
import com.northernwall.hadrian.service.helper.ReadVersionRunnable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceGetHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final MavenHelper mavenHelper;
    private final InfoHelper infoHelper;
    private final ExecutorService executorService;

    public ServiceGetHandler(AccessHelper accessHelper, DataAccess dataAccess, ConfigHelper configHelper, MavenHelper mavenHelper, InfoHelper infoHelper) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.mavenHelper = mavenHelper;
        this.infoHelper = infoHelper;
        this.executorService = Executors.newFixedThreadPool(20);
    }

    /*
     * WARNING - void declaration
     */
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        Service service = this.getService(request);
        GetServiceData getServiceData = GetServiceData.create(service);
        getServiceData.canModify = this.accessHelper.canUserModify(request, service.getTeamId());
        if (service.isActive()) {
            LinkedList<Future> futures = new LinkedList<Future>();
            List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
            Collections.sort(modules);
            for (Module module : modules) {
                GetModuleData getModuleData = GetModuleData.create(module, this.configHelper.getConfig());
                futures.add(this.executorService.submit(new ReadMavenVersionsRunnable(getModuleData, this.mavenHelper)));
                getServiceData.modules.add(getModuleData);
            }
            List<Vip> vips = this.getDataAccess().getVips(service.getServiceId());
            Collections.sort(vips);
            for (Vip vip : vips) {
                void var12_20;
                Object var12_21 = null;
                for (GetModuleData getModuleData : getServiceData.modules) {
                    if (!vip.getModuleId().equals(getModuleData.moduleId)) continue;
                    GetModuleData getModuleData2 = getModuleData;
                }
                if (var12_20 == null) continue;
                GetVipData getVipData = GetVipData.create(vip);
                var12_20.addVip(getVipData);
            }
            List<Host> list = this.getDataAccess().getHosts(service.getServiceId());
            Collections.sort(list);
            for (Host host : list) {
                GetModuleData getModuleData = null;
                for (GetModuleData temp : getServiceData.modules) {
                    if (!host.getModuleId().equals(temp.moduleId)) continue;
                    getModuleData = temp;
                }
                if (getModuleData == null) continue;
                GetHostData getHostData = GetHostData.create(host);
                futures.add(this.executorService.submit(new ReadVersionRunnable(getHostData, getModuleData, this.infoHelper)));
                futures.add(this.executorService.submit(new ReadAvailabilityRunnable(getHostData, getModuleData, this.infoHelper)));
                for (VipRef vipRef : this.getDataAccess().getVipRefsByHost(getHostData.hostId)) {
                    GetVipRefData getVipRefData = GetVipRefData.create(vipRef);
                    for (GetVipData vip : getModuleData.getVips(host.getNetwork())) {
                        if (!vip.vipId.equals(getVipRefData.vipId)) continue;
                        getVipRefData.vipName = vip.vipName;
                    }
                    getHostData.vipRefs.add(getVipRefData);
                }
                getModuleData.addHost(getHostData);
            }
            List<DataStore> list2 = this.getDataAccess().getDataStores(service.getServiceId());
            Collections.sort(list2);
            for (DataStore dataStore : list2) {
                GetDataStoreData getDataStoreData = GetDataStoreData.create(dataStore);
                getServiceData.dataStores.add(getDataStoreData);
            }
            for (ServiceRef ref : this.getDataAccess().getServiceRefsByClient(service.getServiceId())) {
                GetServiceRefData getServiceRefData = GetServiceRefData.create(ref);
                getServiceRefData.serviceName = this.getService(ref.getServerServiceId(), null, null).getServiceName();
                getServiceData.uses.add(getServiceRefData);
            }
            Collections.sort(getServiceData.uses);
            for (ServiceRef ref : this.getDataAccess().getServiceRefsByServer(service.getServiceId())) {
                GetServiceRefData getServiceRefData = GetServiceRefData.create(ref);
                getServiceRefData.serviceName = this.getService(ref.getClientServiceId(), null, null).getServiceName();
                getServiceData.usedBy.add(getServiceRefData);
            }
            Collections.sort(getServiceData.usedBy);
            List<CustomFunction> list3 = this.getDataAccess().getCustomFunctions(service.getServiceId());
            Collections.sort(list3);
            for (CustomFunction customFunction : list3) {
                for (GetModuleData temp : getServiceData.modules) {
                    if (!customFunction.getModuleId().equals(temp.moduleId)) continue;
                    GetCustomFunctionData getCustomFunctionData = GetCustomFunctionData.create(customFunction);
                    temp.customFunctions.add(getCustomFunctionData);
                }
            }
            this.waitForFutures(futures);
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            ServiceGetHandler.getGson().toJson((Object)getServiceData, GetServiceData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void waitForFutures(List<Future> futures) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futures.removeIf(new Predicate<Future>(){

                @Override
                public boolean test(Future t) {
                    return t.isDone();
                }
            });
            if (!futures.isEmpty()) continue;
            return;
        }
    }
}

