/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.GetAuditData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAuditGetHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceAuditGetHandler.class);
    private final DateFormat format = new SimpleDateFormat("MM/dd/yyyy");

    public ServiceAuditGetHandler(DataAccess dataAccess) {
        super(dataAccess);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String start = request.getParameter("start");
        String end = request.getParameter("end");
        String id = request.getParameter("serviceId");
        GetAuditData auditData = new GetAuditData();
        Date startDate = null;
        try {
            startDate = this.format.parse(start);
        }
        catch (ParseException ex) {
            Calendar now = Calendar.getInstance();
            now.add(5, -15);
            now.clear(10);
            now.clear(12);
            now.clear(13);
            startDate = now.getTime();
        }
        Date endDate = null;
        try {
            endDate = this.format.parse(end);
        }
        catch (ParseException ex) {
            Calendar now = Calendar.getInstance();
            now.add(5, 1);
            now.clear(10);
            now.clear(12);
            now.clear(13);
            endDate = now.getTime();
        }
        logger.info("Audit search from {} to {} on service {}", new Object[]{startDate.toString(), endDate.toString(), id});
        auditData.audits = this.getDataAccess().getAudit(id, startDate, endDate);
        Collections.sort(auditData.audits);
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            ServiceAuditGetHandler.getGson().toJson((Object)auditData, GetAuditData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

