/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.GitMode;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.PostModuleData;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleCreateHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(ModuleCreateHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final WorkItemProcessor workItemProcess;

    public ModuleCreateHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostModuleData data = this.fromJson(request, PostModuleData.class);
        Service service = this.getService(data.serviceId, null, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a module");
        Config config = this.configHelper.getConfig();
        if (!config.moduleTypes.contains((Object)data.moduleType)) {
            throw new Http400BadRequestException("Unknown module type");
        }
        String template = null;
        switch (data.moduleType) {
            case Deployable: {
                if (!config.deployableTemplates.contains(data.deployableTemplate)) {
                    throw new Http400BadRequestException("Unknown deployable template");
                }
                template = data.deployableTemplate;
                break;
            }
            case Library: {
                if (!config.libraryTemplates.contains(data.libraryTemplate)) {
                    throw new Http400BadRequestException("Unknown library template");
                }
                template = data.libraryTemplate;
                break;
            }
            case Test: {
                if (!config.testTemplates.contains(data.testTemplate)) {
                    throw new Http400BadRequestException("Unknown test template");
                }
                template = data.testTemplate;
            }
        }
        if (!config.artifactTypes.contains(data.artifactType)) {
            throw new Http400BadRequestException("Unknown artifact");
        }
        if (service.getServiceType().equals("Shared Library")) {
            data.moduleType = ModuleType.Library;
        }
        if (!data.moduleType.equals((Object)ModuleType.Deployable)) {
            data.hostAbbr = "";
            data.versionUrl = "";
            data.availabilityUrl = "";
            data.runAs = "";
            data.deploymentFolder = "";
            data.startCmdLine = "";
            data.startTimeOut = 0;
            data.stopCmdLine = "";
            data.stopTimeOut = 0;
        } else if (data.hostAbbr.contains("-")) {
            throw new Http400BadRequestException("Can not have '-' in host abbr");
        }
        if (service.getGitMode().equals((Object)GitMode.Consolidated)) {
            data.gitProject = service.getGitProject();
            if (data.gitFolder.startsWith("/")) {
                data.gitFolder = data.gitFolder.substring(1);
            }
        } else {
            data.gitFolder = "";
        }
        List<Module> modules = this.getDataAccess().getModules(data.serviceId);
        LinkedList<Module> zeroModules = new LinkedList<Module>();
        for (Module temp : modules) {
            if (data.moduleName.equalsIgnoreCase(temp.getModuleName())) {
                logger.warn("Error there already exists a module named {} on service {}", (Object)data.moduleName, (Object)data.serviceId);
                return;
            }
            if (data.gitProject.equalsIgnoreCase(temp.getGitProject()) && data.gitFolder.equalsIgnoreCase(temp.getGitFolder())) {
                logger.warn("Error there already exists a module with git project {} and folder {} on service {}", new Object[]{data.gitProject, data.gitFolder, data.serviceId});
                return;
            }
            if (temp.getOrder() != 0) continue;
            zeroModules.add(temp);
        }
        modules.removeAll(zeroModules);
        Collections.sort(modules);
        if (data.order < 0) {
            data.order = 0;
        }
        if (data.order > 0) {
            if (data.order > modules.size() + 1) {
                data.order = modules.size() + 1;
            }
            for (Module temp : modules) {
                if (temp.getOrder() < data.order) continue;
                temp.setOrder(temp.getOrder() + 1);
                this.getDataAccess().updateModule(temp);
            }
        }
        Module module = new Module(data.moduleName, data.serviceId, data.order, data.moduleType, data.gitProject, data.gitFolder, data.mavenGroupId, data.mavenArtifactId, data.artifactType, data.artifactSuffix, data.hostAbbr.toLowerCase(), data.versionUrl, data.availabilityUrl, data.runAs, data.deploymentFolder, data.startCmdLine, data.startTimeOut, data.stopCmdLine, data.stopTimeOut);
        this.getDataAccess().saveModule(module);
        if (module.getOrder() > 0) {
            modules.add(module.getOrder() - 1, module);
        } else {
            zeroModules.add(module);
        }
        WorkItem workItem = new WorkItem(Type.module, Operation.create, user, team, service, module, null, null);
        workItem.getMainModule().template = template;
        for (Module temp : zeroModules) {
            workItem.addModule(temp);
        }
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.getDataAccess().saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

