/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.DeleteHostVipData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostVipDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcess;

    public HostVipDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteHostVipData data = this.fromJson(request, DeleteHostVipData.class);
        Service service = this.getService(data.serviceId, null, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "delete host vip");
        VipRef vipRef = this.getDataAccess().getVipRef(data.hostId, data.vipId);
        if (vipRef == null) {
            return;
        }
        Host host = this.getHost(data.hostId, null, service);
        Vip vip = this.getVip(data.vipId, null, service);
        vipRef.setStatus("Removing...");
        this.getDataAccess().updateVipRef(vipRef);
        WorkItem workItem = new WorkItem(Type.hostvip, Operation.delete, user, team, service, null, host, vip);
        this.getDataAccess().saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

