/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.PostHostVipData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostVipCreateHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostVipCreateHandler.class);
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcess;

    public HostVipCreateHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostHostVipData data = this.fromJson(request, PostHostVipData.class);
        Service service = this.getService(data.serviceId, null, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a host vip");
        List<Host> hosts = this.getDataAccess().getHosts(data.serviceId);
        Vip vip = this.getVip(data.vipId, null, service);
        Module module = null;
        for (Host host : hosts) {
            if (!data.hostNames.contains(host.getHostName())) continue;
            if (host.getNetwork().equals(vip.getNetwork())) {
                if (module == null || host.getModuleId().equals(module.getModuleId())) {
                    for (Module temp : this.getDataAccess().getModules(host.getServiceId())) {
                        if (!temp.getModuleId().equals(host.getModuleId())) continue;
                        module = temp;
                    }
                }
                this.getDataAccess().saveVipRef(new VipRef(host.getHostId(), vip.getVipId(), "Adding..."));
                WorkItem workItem = new WorkItem(Type.hostvip, Operation.create, user, team, service, module, host, vip);
                this.getDataAccess().saveWorkItem(workItem);
                this.workItemProcess.sendWorkItem(workItem);
                continue;
            }
            logger.warn("Request to add {} to {} reject because they are not on the same network", (Object)host.getHostName(), (Object)vip.getVipName());
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

