/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.PutRestartHostData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostRestartHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcess;

    public HostRestartHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutRestartHostData data = this.fromJson(request, PutRestartHostData.class);
        Service service = this.getService(data.serviceId, data.serviceName, data.serviceAbbr);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanRestart(request, service.getTeamId());
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(hosts.size());
        for (Host host : hosts) {
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getNetwork().equals(data.network) || !data.all && !data.hostNames.contains(host.getHostName()) || !host.getStatus().equals("-")) continue;
            WorkItem workItem = new WorkItem(Type.host, Operation.restart, user, team, service, module, host, null);
            workItem.getHost().reason = data.reason;
            if (workItems.isEmpty()) {
                host.setStatus("Restarting...");
            } else {
                host.setStatus("Restart Queued");
            }
            this.getDataAccess().updateHost(host);
            workItems.add(workItem);
        }
        String prevId = null;
        int size = workItems.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                WorkItem workItem = (WorkItem)workItems.get(size - i - 1);
                workItem.setNextId(prevId);
                prevId = workItem.getId();
                this.getDataAccess().saveWorkItem(workItem);
            }
            this.workItemProcess.sendWorkItem((WorkItem)workItems.get(0));
            if (data.wait) {
                String lastId = ((WorkItem)workItems.get(size - 1)).getId();
                for (int i = 0; i < 30; ++i) {
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    WorkItem workItem = this.getDataAccess().getWorkItem(lastId);
                    if (workItem != null) continue;
                    response.setStatus(200);
                    request.setHandled(true);
                    return;
                }
            }
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

