/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.service.dao.GetHostDetailsData;
import com.northernwall.hadrian.service.helper.HostDetailsHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostGetDetailsHandler
extends BasicHandler {
    private final HostDetailsHelper hostDetailsHelper;

    public HostGetDetailsHandler(DataAccess dataAccess, HostDetailsHelper hostDetailsHelper) {
        super(dataAccess);
        this.hostDetailsHelper = hostDetailsHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Host host = this.getHost(request, service);
        GetHostDetailsData details = this.hostDetailsHelper.getDetails(host);
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            HostGetDetailsHandler.getGson().toJson((Object)details, GetHostDetailsData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

