/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.BasicHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostBackfillHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostBackfillHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;

    public HostBackfillHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        User user = this.accessHelper.checkIfUserIsOps(request, "Backfill");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String s = reader.readLine();
        while (s != null && !s.isEmpty()) {
            String[] parts = s.split(",");
            if (parts.length == 7) {
                this.backfillHost(parts[0].trim(), parts[1].trim(), parts[2].trim(), parts[3].trim(), parts[4].trim(), parts[5].trim(), parts[6].trim(), user);
            }
            s = reader.readLine();
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void backfillHost(String serviceAbbr, String moduleName, String hostName, String dataCenter, String network, String env, String size, User user) {
        Config config = this.configHelper.getConfig();
        if (config.dataCenters.contains(dataCenter) && config.networkNames.contains(network) && config.envs.contains(env) && config.sizes.contains(size)) {
            for (Service service : this.getDataAccess().getServices()) {
                if (!service.getServiceAbbr().equalsIgnoreCase(serviceAbbr)) continue;
                List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
                for (Host host : hosts) {
                    if (!host.getHostName().equalsIgnoreCase(hostName)) continue;
                    logger.warn("There already exists host '{}' on service '{}'", (Object)hostName, (Object)serviceAbbr);
                    return;
                }
                Module module = null;
                List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
                for (Module temp : modules) {
                    if (!temp.getModuleName().equalsIgnoreCase(moduleName)) continue;
                    module = temp;
                }
                if (module == null) {
                    logger.warn("Could not find module with name {} in service {}", (Object)moduleName, (Object)serviceAbbr);
                    return;
                }
                Host host = new Host(hostName, service.getServiceId(), "-", module.getModuleId(), dataCenter, network, env, size);
                this.getDataAccess().saveHost(host);
                Audit audit = new Audit();
                audit.serviceId = service.getServiceId();
                audit.timePerformed = this.getGmt();
                audit.timeRequested = this.getGmt();
                audit.requestor = user.getUsername();
                audit.type = Type.host;
                audit.operation = Operation.create;
                audit.moduleName = module.getModuleName();
                audit.hostName = hostName;
                HashMap<String, String> notes = new HashMap<String, String>();
                notes.put("reason", "Backfill via OPS tool.");
                audit.notes = HostBackfillHandler.getGson().toJson(notes);
                this.getDataAccess().saveAudit(audit, null);
                return;
            }
            logger.warn("Could not find a service with the abbr '{}'", (Object)serviceAbbr);
        }
    }
}

