/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.northernwall.hadrian.Const;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.service.BasicHandler;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http404NotFoundException;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class CustomFuntionExecHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final OkHttpClient client;

    public CustomFuntionExecHandler(AccessHelper accessHelper, DataAccess dataAccess, OkHttpClient client) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.client = client;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        String customFunctionId = request.getParameter("cfId");
        CustomFunction customFunction = this.getDataAccess().getCustomFunction(service.getServiceId(), customFunctionId);
        if (customFunction == null) {
            throw new Http404NotFoundException("Could not find custom function");
        }
        if (customFunction.isTeamOnly()) {
            this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "execute a private custom function");
        }
        Host host = this.getHost(request, service);
        if (!customFunction.getServiceId().equals(host.getServiceId())) {
            throw new Http400BadRequestException("Custom Function and Host do not belong to the same service");
        }
        if (!customFunction.getModuleId().equals(host.getModuleId())) {
            throw new Http400BadRequestException("Custom Function and Host do not belong to the same module");
        }
        Request.Builder builder = new Request.Builder();
        builder.url("http://" + customFunction.getUrl().replace("{host}", host.getHostName()));
        if (customFunction.getMethod().equalsIgnoreCase("POST")) {
            RequestBody body = RequestBody.create((MediaType)Const.JSON_MEDIA_TYPE, (String)"{}");
            builder.post(body);
        }
        com.squareup.okhttp.Request cfRequest = builder.build();
        try {
            Response resp = this.client.newCall(cfRequest).execute();
            InputStream inputStream = resp.body().byteStream();
            byte[] buffer = new byte[51200];
            int len = inputStream.read(buffer);
            while (len != -1) {
                response.getOutputStream().write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
        }
        catch (UnknownHostException ex) {
            response.getOutputStream().print("Error: Unknown host!");
        }
        catch (ConnectException | SocketTimeoutException ex) {
            response.getOutputStream().print("Error: Time out!");
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

