/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.utilityHandlers.routingHandler.Http404NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(BasicHandler.class);
    private static final Gson gson = new Gson();
    private final DataAccess dataAccess;

    public BasicHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public static Gson getGson() {
        return gson;
    }

    protected final <T> T fromJson(Request request, Class<T> classOfT) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
        Object temp = gson.fromJson((Reader)reader, classOfT);
        if (temp == null) {
            logger.warn("Stream->Json returned null");
            throw new Http400BadRequestException("JSON payload is missing");
        }
        logger.info("Stream->Json {}", (Object)gson.toJson(temp));
        return (T)temp;
    }

    protected Team getTeam(Request request) {
        return this.getTeam(request.getParameter("teamId"), request.getParameter("teamName"));
    }

    protected Team getTeam(String teamId, String teamName) {
        if (teamId != null && !teamId.isEmpty()) {
            Team team = this.dataAccess.getTeam(teamId);
            if (team != null) {
                return team;
            }
            throw new Http404NotFoundException("Could not find team with ID " + teamId);
        }
        if (teamName != null && !teamName.isEmpty()) {
            for (Team team : this.dataAccess.getTeams()) {
                if (!team.getTeamName().equalsIgnoreCase(teamName)) continue;
                return team;
            }
        }
        throw new Http404NotFoundException("Could not find team");
    }

    protected Service getService(Request request) {
        return this.getService(request.getParameter("serviceId"), request.getParameter("serviceName"), request.getParameter("serviceAbbr"));
    }

    protected Service getService(String serviceId, String serviceName, String serviceAbbr) {
        if (serviceId != null && !serviceId.isEmpty()) {
            Service service = this.dataAccess.getService(serviceId);
            if (service != null) {
                return service;
            }
            throw new Http404NotFoundException("Could not find service with ID " + serviceId);
        }
        if (serviceName != null && !serviceName.isEmpty()) {
            for (Service service : this.dataAccess.getServices()) {
                if (!service.getServiceName().equalsIgnoreCase(serviceName)) continue;
                return service;
            }
        }
        if (serviceAbbr != null && !serviceAbbr.isEmpty()) {
            for (Service service : this.dataAccess.getServices()) {
                if (!service.getServiceAbbr().equalsIgnoreCase(serviceAbbr)) continue;
                return service;
            }
        }
        throw new Http404NotFoundException("Could not find service");
    }

    protected Module getModule(String moduleId, String moduleName, Service service) {
        Module module;
        if (moduleId != null && !moduleId.isEmpty() && (module = this.dataAccess.getModule(service.getServiceId(), moduleId)) != null) {
            return module;
        }
        if (moduleName != null && !moduleName.isEmpty()) {
            for (Module module2 : this.dataAccess.getModules(service.getServiceId())) {
                if (!module2.getModuleName().equalsIgnoreCase(moduleName)) continue;
                return module2;
            }
        }
        throw new Http404NotFoundException("Could not find module");
    }

    protected Host getHost(Request request, Service service) {
        return this.getHost(request.getParameter("hostId"), request.getParameter("hostName"), service);
    }

    protected Host getHost(String hostId, String hostName, Service service) {
        Host host;
        if (hostId != null && !hostId.isEmpty() && (host = this.dataAccess.getHost(service.getServiceId(), hostId)) != null) {
            return host;
        }
        if (hostName != null && !hostName.isEmpty()) {
            for (Host host2 : this.dataAccess.getHosts(service.getServiceId())) {
                if (!host2.getHostName().equalsIgnoreCase(hostName)) continue;
                return host2;
            }
        }
        throw new Http404NotFoundException("Could not find host");
    }

    protected Vip getVip(String vipId, String vipName, Service service) {
        Vip vip;
        if (vipId != null && !vipId.isEmpty() && (vip = this.dataAccess.getVip(service.getServiceId(), vipId)) != null) {
            return vip;
        }
        if (vipName != null && !vipName.isEmpty()) {
            for (Vip vip2 : this.dataAccess.getVips(service.getServiceId())) {
                if (!vip2.getVipName().equalsIgnoreCase(vipName)) continue;
                return vip2;
            }
        }
        throw new Http404NotFoundException("Could not find vip");
    }

    protected Date getGmt() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
    }
}

