/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.maven.http;

import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMavenHelper
extends MavenHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpMavenHelper.class);
    private final OkHttpClient client;
    private String mavenRepo;
    private String mavenUsername;
    private String mavenPassword;

    public HttpMavenHelper(Parameters parameters, OkHttpClient client) {
        super(parameters);
        this.client = client;
    }

    @Override
    public void setup() {
        super.setup();
        this.mavenRepo = this.parameters.getString("maven.http.url", "http://127.0.0.1/mvnrepo/internal/");
        this.mavenUsername = this.parameters.getString("maven.http.username", "-");
        this.mavenPassword = this.parameters.getString("maven.http.password", "-");
    }

    @Override
    public List<String> readMavenVersions(String groupId, String artifactId) {
        List<String> versions = new LinkedList<String>();
        if (groupId != null && !groupId.isEmpty() && artifactId != null && !artifactId.isEmpty()) {
            try {
                Request.Builder builder = new Request.Builder();
                String url = this.mavenRepo + groupId.replace(".", "/") + "/" + artifactId + "/maven-metadata.xml";
                builder.url(url);
                if (!this.mavenUsername.equals("-")) {
                    String credential = Credentials.basic((String)this.mavenUsername, (String)this.mavenPassword);
                    builder.header("Authorization", credential);
                }
                Request request = builder.build();
                Response response = this.client.newCall(request).execute();
                try (InputStream inputStream = response.body().byteStream();){
                    versions = this.processMavenStream(inputStream);
                }
            }
            catch (Exception ex) {
                logger.error("Error reading maven version from {} {}, {}", new Object[]{groupId, artifactId, ex.getMessage()});
            }
        }
        if (versions.isEmpty()) {
            versions.add("0.0.0");
        }
        return versions;
    }
}

