/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.maven;

import com.northernwall.hadrian.maven.MavenVersionComparator;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MavenHelper
implements ParameterChangeListener {
    protected final Parameters parameters;
    private final MavenVersionComparator mavenVersionComparator;
    private int maxMavenVersions;

    public MavenHelper(Parameters parameters) {
        this.parameters = parameters;
        this.mavenVersionComparator = new MavenVersionComparator();
    }

    public void setup() {
        this.maxMavenVersions = this.parameters.getInt("maven.maxVersions", 15);
    }

    @Override
    public void onChange(List<String> keys) {
        this.setup();
    }

    public abstract List<String> readMavenVersions(String var1, String var2);

    protected List<String> processMavenStream(InputStream inputStream) throws Exception {
        LinkedList<String> versions = new LinkedList<String>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        Element root = doc.getDocumentElement();
        Node versionsNode = root.getElementsByTagName("versions").item(0);
        for (int i = 0; i < versionsNode.getChildNodes().getLength(); ++i) {
            Node child = versionsNode.getChildNodes().item(i);
            if (child.getNodeType() != 1 || child.getTextContent().endsWith("SNAPSHOT")) continue;
            versions.add(child.getTextContent());
        }
        Collections.sort(versions, this.mavenVersionComparator);
        if (versions.size() > this.maxMavenVersions) {
            return versions.subList(0, this.maxMavenVersions);
        }
        return versions;
    }
}

