/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.graph;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.graph.Graph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class GraphFanOutHandler
extends AbstractHandler {
    private final DataAccess dataAccess;

    public GraphFanOutHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String serviceId = target.substring(17);
        response.setContentType("text/plain; charset=utf-8");
        Graph graph = new Graph((OutputStream)response.getOutputStream());
        LinkedList<Service> services = new LinkedList<Service>();
        LinkedList<String> foundIds = new LinkedList<String>();
        Service service = this.dataAccess.getService(serviceId);
        services.add(service);
        foundIds.add(service.getServiceId());
        while (!services.isEmpty()) {
            this.fanOut((Service)services.remove(0), graph, services, foundIds);
        }
        graph.newLine();
        graph.writeService(service, "rectangle", false);
        graph.close();
        request.setHandled(true);
        response.setStatus(200);
    }

    private void fanOut(Service service, Graph graph, List<Service> services, List<String> foundIds) throws IOException {
        List<ServiceRef> serviceRefs = this.dataAccess.getServiceRefsByClient(service.getServiceId());
        if (serviceRefs != null && !serviceRefs.isEmpty()) {
            for (ServiceRef serviceRef : serviceRefs) {
                if (foundIds.contains(serviceRef.getServerServiceId())) continue;
                Service temp = this.dataAccess.getService(serviceRef.getServerServiceId());
                graph.writeLink(service.getServiceAbbr(), temp.getServiceAbbr());
                graph.writeService(temp, "ellipse", true);
                services.add(temp);
                foundIds.add(temp.getServiceId());
            }
        }
    }
}

