/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.graph;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.graph.Graph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class GraphAllHandler
extends AbstractHandler {
    private final DataAccess dataAccess;

    public GraphAllHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain; charset=utf-8");
        Graph graph = new Graph((OutputStream)response.getOutputStream());
        List<Team> teams = this.dataAccess.getTeams();
        if (teams != null && !teams.isEmpty()) {
            List<ServiceRef> serverRefs;
            List<Service> services;
            int c = 0;
            for (Team team : teams) {
                services = this.dataAccess.getServices(team.getTeamId());
                if (services != null && !services.isEmpty()) {
                    graph.startSubGraph(c);
                    for (Service service : services) {
                        serverRefs = this.dataAccess.getServiceRefsByServer(service.getServiceId());
                        List<ServiceRef> clientRefs = this.dataAccess.getServiceRefsByClient(service.getServiceId());
                        String toolTip = this.writeToolTip(service, serverRefs, clientRefs);
                        if (serverRefs != null && serverRefs.size() > 5) {
                            graph.writeService(service, "rectangle", true, toolTip);
                            continue;
                        }
                        graph.writeService(service, "ellipse", true, toolTip);
                    }
                    graph.finishSubGraph(team.getTeamName());
                }
                ++c;
            }
            for (Team team : teams) {
                services = this.dataAccess.getServices(team.getTeamId());
                if (services == null || services.isEmpty()) continue;
                for (Service service : services) {
                    serverRefs = this.dataAccess.getServiceRefsByServer(service.getServiceId());
                    if (serverRefs == null || serverRefs.isEmpty() || serverRefs.size() > 5) continue;
                    for (ServiceRef serviceRef : serverRefs) {
                        Service temp = this.dataAccess.getService(serviceRef.getClientServiceId());
                        graph.writeLink(temp.getServiceAbbr(), service.getServiceAbbr());
                    }
                }
                graph.newLine();
            }
        }
        graph.close();
        request.setHandled(true);
        response.setStatus(200);
    }

    private String writeToolTip(Service service, List<ServiceRef> serverRefs, List<ServiceRef> clientRefs) {
        StringBuilder temp = new StringBuilder();
        if (clientRefs != null && !clientRefs.isEmpty()) {
            temp.append(service.getServiceAbbr());
            temp.append(" uses ");
            temp.append(clientRefs.size());
            temp.append(" services");
        }
        if (clientRefs != null && !clientRefs.isEmpty() && serverRefs != null && !serverRefs.isEmpty()) {
            temp.append(" and ");
        }
        if (serverRefs != null && !serverRefs.isEmpty()) {
            temp.append(serverRefs.size());
            temp.append(" services use ");
            temp.append(service.getServiceAbbr());
        }
        if (clientRefs != null && !clientRefs.isEmpty() || serverRefs != null && !serverRefs.isEmpty()) {
            temp.append(".");
        }
        return temp.toString();
    }
}

