/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.graph;

import com.northernwall.hadrian.domain.Service;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Graph {
    private final BufferedWriter writer;

    public Graph(OutputStream outputStream) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.writer.append("digraph G {");
        this.writer.newLine();
    }

    public void startSubGraph(int c) throws IOException {
        this.writer.append(" subgraph cluster_");
        this.writer.append(Integer.toString(c));
        this.writer.append(" {");
        this.writer.newLine();
        this.writer.append("  color=blue;");
        this.writer.newLine();
        this.writer.append("  node [style=filled];");
        this.writer.newLine();
    }

    public void finishSubGraph(String teamName) throws IOException {
        this.writer.append("  label = \"");
        this.writer.append(teamName);
        this.writer.append("\";");
        this.writer.newLine();
        this.writer.append(" }");
        this.writer.newLine();
        this.writer.newLine();
    }

    public void newLine() throws IOException {
        this.writer.newLine();
    }

    public void writeService(Service service, String shape, boolean brief) throws IOException {
        this.writeService(service, shape, brief, null);
    }

    public void writeService(Service service, String shape, boolean brief, String toolTip) throws IOException {
        this.writer.append(service.getServiceAbbr());
        this.writer.append(" [shape=");
        this.writer.append(shape);
        this.writer.append(" URL=\"#/Service/");
        this.writer.append(service.getServiceId());
        this.writer.append("\"");
        this.writer.append(" label=<");
        if (brief) {
            this.writer.append(service.getServiceAbbr());
        } else {
            this.writer.append(service.getServiceName());
        }
        this.writer.append(">");
        if (toolTip != null && !toolTip.isEmpty()) {
            this.writer.append(" tooltip=<");
            this.writer.append(toolTip);
            this.writer.append(">");
        }
        this.writer.append("];");
        this.writer.newLine();
    }

    public void writeLink(String serviceA, String serviceB) throws IOException {
        this.writer.append(" ");
        this.writer.append(serviceA);
        this.writer.append(" -> ");
        this.writer.append(serviceB);
        this.writer.append(";");
        this.writer.newLine();
    }

    public void close() throws IOException {
        this.writer.append("}");
        this.writer.flush();
    }
}

