/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.DataAccessFactory;
import com.northernwall.hadrian.db.cassandra.CassandraDataAccess;
import com.northernwall.hadrian.parameters.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataAccessFactory
implements DataAccessFactory,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CassandraDataAccessFactory.class);
    private Cluster cluster;
    private CassandraDataAccess dataAccess;

    @Override
    public DataAccess createDataAccess(Parameters parameters, MetricRegistry metricRegistry) {
        String nodes = parameters.getString("dataAccess.cassandra.nodes", "127.0.0.1");
        String dataCenter = parameters.getString("dataAccess.cassandra.dataCenter", null);
        String username = parameters.getString("dataAccess.cassandra.username", null);
        String password = parameters.getString("dataAccess.cassandra.password", null);
        boolean createKeyspace = parameters.getBoolean("dataAccess.cassandra.createKeyspace", true);
        String keyspace = parameters.getString("dataAccess.cassandra.keyspace", "hadrian");
        int replicationFactor = parameters.getInt("dataAccess.cassandra.replicationFactor", 1);
        int auditTimeToLive = parameters.getInt("dataAccess.cassandra.auditTtlDays", 732) * 86400;
        this.connect(nodes, dataCenter, username, password);
        this.setup(createKeyspace, keyspace, replicationFactor);
        Thread thread = new Thread(this);
        Runtime.getRuntime().addShutdownHook(thread);
        this.dataAccess = new CassandraDataAccess(this.cluster, keyspace, username, dataCenter, auditTimeToLive, metricRegistry);
        return this.dataAccess;
    }

    private void connect(String nodes, String dataCenter, String username, String password) {
        String[] nodeParts;
        Cluster.Builder builder = Cluster.builder();
        if (nodes == null || nodes.isEmpty()) {
            throw new RuntimeException("dataAccess.cassandra.nodes is not defined");
        }
        if (dataCenter != null && !dataCenter.isEmpty()) {
            builder.withLoadBalancingPolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy(dataCenter));
        }
        for (String node : nodeParts = nodes.split(",")) {
            if ((node = node.trim()).isEmpty()) continue;
            logger.info("Adding Cassandra node {}", (Object)node);
            builder.addContactPoint(node);
        }
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            builder.withCredentials(username, password);
        }
        this.cluster = builder.build();
        Metadata metadata = this.cluster.getMetadata();
        logger.info("Connected to cluster: {}", (Object)metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            logger.info("Datacenter: {} Host: {} Rack: {}", new Object[]{host.getDatacenter(), host.getAddress(), host.getRack()});
        }
    }

    private void setup(boolean createKeyspace, String keyspace, int replicationFactor) {
        Session session = this.cluster.connect();
        if (createKeyspace) {
            session.execute("CREATE KEYSPACE IF NOT EXISTS " + keyspace + " WITH replication = {'class':'SimpleStrategy', 'replication_factor':" + replicationFactor + "};");
            logger.info("Keyspace {} created", (Object)keyspace);
        } else {
            logger.info("Not calling create keyspace for {}", (Object)keyspace);
        }
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".version (component text, version text, PRIMARY KEY (component));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".service (id text, data text, PRIMARY KEY (id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".team (id text, data text, PRIMARY KEY (id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".user (id text, data text, PRIMARY KEY (id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".workItem (id text, data text, PRIMARY KEY (id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".customFunction (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".dataStore (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".host (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".module (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".vip (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".serviceRefClient (clientServiceId text, serverServiceId text, PRIMARY KEY (clientServiceId, serverServiceId));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".serviceRefServer (serverServiceId text, clientServiceId text, PRIMARY KEY (serverServiceId, clientServiceId));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".vipRefHost (hostId text, vipId text, data text, PRIMARY KEY (hostId, vipId));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".vipRefVip(vipId text, hostId text, PRIMARY KEY (vipId, hostId));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".audit (serviceId text, time timeuuid, data text, PRIMARY KEY (serviceId, time));");
        session.execute("CREATE TABLE IF NOT EXISTS " + keyspace + ".auditOutput (serviceId text, auditId text, data text, PRIMARY KEY (serviceId, auditId));");
        logger.info("Tables created");
        session.close();
    }

    @Override
    public void run() {
        this.dataAccess.close();
        this.cluster.close();
        logger.info("Connection to cluster closed");
    }
}

