/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.northernwall.hadrian.Hadrian;
import com.northernwall.hadrian.access.AccessHandlerFactory;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.calendar.CalendarHelperFactory;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.DataAccessFactory;
import com.northernwall.hadrian.db.DataAccessUpdater;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.maven.MavenHelperFactory;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.WorkItemSender;
import com.northernwall.hadrian.workItem.WorkItemSenderFactory;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadrianBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HadrianBuilder.class);
    private final Parameters parameters;
    private OkHttpClient client;
    private DataAccess dataAccess;
    private MavenHelper mavenHelper;
    private AccessHelper accessHelper;
    private Handler accessHandler;
    private CalendarHelper calendarHelper;
    private WorkItemSender workItemSender;
    private MetricRegistry metricRegistry;

    public static HadrianBuilder create(Parameters parameters) {
        return new HadrianBuilder(parameters);
    }

    private HadrianBuilder(Parameters parameters) {
        this.parameters = parameters;
    }

    public HadrianBuilder setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        return this;
    }

    public HadrianBuilder setMavenHelper(MavenHelper mavenHelper) {
        this.mavenHelper = mavenHelper;
        return this;
    }

    public HadrianBuilder setAccessHandler(Handler accessHandler) {
        this.accessHandler = accessHandler;
        return this;
    }

    public HadrianBuilder setWorkItemSender(WorkItemSender workItemSender) {
        this.workItemSender = workItemSender;
        return this;
    }

    public HadrianBuilder setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        return this;
    }

    public Hadrian builder() {
        Class<?> c;
        String factoryName;
        try {
            this.client = new OkHttpClient();
            this.client.setConnectTimeout(2L, TimeUnit.SECONDS);
            this.client.setReadTimeout(2L, TimeUnit.SECONDS);
            this.client.setWriteTimeout(2L, TimeUnit.SECONDS);
            this.client.setFollowSslRedirects(false);
            this.client.setFollowRedirects(false);
            this.client.setConnectionPool(new ConnectionPool(5, 60000L));
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Error Creating HTTPClient, could not parse property");
        }
        catch (Exception e) {
            throw new RuntimeException("Error Creating HTTPClient: ", e);
        }
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
            final OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            this.metricRegistry.register("jvm.processCpuLoad", (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return osBean.getProcessCpuLoad();
                }
            });
            this.metricRegistry.register("jvm.systemCpuLoad", (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return osBean.getSystemCpuLoad();
                }
            });
            if (this.parameters.getBoolean("metrics.console", false)) {
                ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start(1L, TimeUnit.MINUTES);
            }
            String graphiteUrl = this.parameters.getString("metrics.graphite.url", null);
            int graphitePort = this.parameters.getInt("metrics.graphite.port", -1);
            if (graphiteUrl != null && graphitePort > -1) {
                Graphite graphite = new Graphite(new InetSocketAddress(graphiteUrl, graphitePort));
                GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith("hadrian." + this.getHostname()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
                reporter.start((long)this.parameters.getInt("metrics.graphite.poll", 20), TimeUnit.SECONDS);
            }
        }
        if (this.dataAccess == null) {
            DataAccessFactory factory;
            factoryName = this.parameters.getString("dataAccess.factoryClassName", "com.northernwall.hadrian.db.inMemory.InMemoryDataAccessFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find DataAccess class " + factoryName);
            }
            try {
                factory = (DataAccessFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation DataAccess class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access DataAccess class " + factoryName);
            }
            this.dataAccess = factory.createDataAccess(this.parameters, this.metricRegistry);
        }
        if (this.mavenHelper == null) {
            MavenHelperFactory mavenHelperFactory;
            factoryName = this.parameters.getString("maven.factoryClassName", "com.northernwall.hadrian.maven.http.HttpMavenHelperFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find MavenHelper class " + factoryName);
            }
            try {
                mavenHelperFactory = (MavenHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation MavenHelper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access MavenHelper class " + factoryName);
            }
            this.mavenHelper = mavenHelperFactory.create(this.parameters, this.client);
        }
        this.accessHelper = new AccessHelper(this.dataAccess);
        if (this.accessHandler == null) {
            AccessHandlerFactory accessHanlderFactory;
            factoryName = this.parameters.getString("accessHandler.factoryClassName", "com.northernwall.hadrian.access.simple.SimpleAccessHandlerFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find Access class " + factoryName);
            }
            try {
                accessHanlderFactory = (AccessHandlerFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation Access class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access Access class " + factoryName);
            }
            this.accessHandler = accessHanlderFactory.create(this.accessHelper, this.parameters, this.metricRegistry);
        }
        if (this.calendarHelper == null) {
            CalendarHelperFactory calendarHelperFactory;
            factoryName = this.parameters.getString("calendarHelper.factoryClassName", "com.northernwall.hadrian.calendar.simple.SimpleCalendarHelperFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find Calendar Helper class " + factoryName);
            }
            try {
                calendarHelperFactory = (CalendarHelperFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation Calendar Helper class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access Calendar Helper class " + factoryName);
            }
            this.calendarHelper = calendarHelperFactory.create(this.parameters, this.client);
        }
        if (this.workItemSender == null) {
            WorkItemSenderFactory workItemSenderFactory;
            factoryName = this.parameters.getString("workItemSender.factoryClassName", "com.northernwall.hadrian.workItem.noop.NoopWorkItemSenderFactory");
            try {
                c = Class.forName(factoryName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not build Hadrian, could not find WorkItemSender class " + factoryName);
            }
            try {
                workItemSenderFactory = (WorkItemSenderFactory)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not build Hadrian, could not instantiation WorkItemSender class " + factoryName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not build Hadrian, could not access WorkItemSender class " + factoryName);
            }
            this.workItemSender = workItemSenderFactory.create(this.parameters, this.client, this.metricRegistry);
        }
        WorkItemProcessor workItemProcessor = new WorkItemProcessor(this.dataAccess, this.workItemSender, this.metricRegistry);
        this.workItemSender.setWorkItemProcessor(workItemProcessor);
        DataAccessUpdater.update(this.dataAccess);
        return new Hadrian(this.parameters, this.client, this.dataAccess, this.mavenHelper, this.accessHelper, this.accessHandler, this.calendarHelper, workItemProcessor, this.metricRegistry);
    }

    private String getHostname() {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            int i = hostname.indexOf(".");
            if (i > 0) {
                hostname = hostname.substring(0, i);
            }
            logger.info("Hostname is {}", (Object)hostname);
            return hostname;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find hostname", e);
        }
    }
}

