/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.codahale.metrics.MetricRegistry;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.graph.GraphAllHandler;
import com.northernwall.hadrian.graph.GraphFanInHandler;
import com.northernwall.hadrian.graph.GraphFanOutHandler;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.service.AuditCreateHandler;
import com.northernwall.hadrian.service.CalendarGetHandler;
import com.northernwall.hadrian.service.ConfigGetHandler;
import com.northernwall.hadrian.service.CustomFuntionCreateHandler;
import com.northernwall.hadrian.service.CustomFuntionDeleteHandler;
import com.northernwall.hadrian.service.CustomFuntionExecHandler;
import com.northernwall.hadrian.service.CustomFuntionModifyHandler;
import com.northernwall.hadrian.service.DataStoreGetHandler;
import com.northernwall.hadrian.service.HostBackfillHandler;
import com.northernwall.hadrian.service.HostCreateHandler;
import com.northernwall.hadrian.service.HostDeleteHandler;
import com.northernwall.hadrian.service.HostDeploySoftwareHandler;
import com.northernwall.hadrian.service.HostGetDetailsHandler;
import com.northernwall.hadrian.service.HostRestartHandler;
import com.northernwall.hadrian.service.HostVipCreateHandler;
import com.northernwall.hadrian.service.HostVipDeleteHandler;
import com.northernwall.hadrian.service.ModuleCreateHandler;
import com.northernwall.hadrian.service.ModuleDeleteHandler;
import com.northernwall.hadrian.service.ModuleModifyHandler;
import com.northernwall.hadrian.service.ServiceAuditGetHandler;
import com.northernwall.hadrian.service.ServiceAuditOutputGetHandler;
import com.northernwall.hadrian.service.ServiceCreateHandler;
import com.northernwall.hadrian.service.ServiceDeleteHandler;
import com.northernwall.hadrian.service.ServiceGetHandler;
import com.northernwall.hadrian.service.ServiceModifyHandler;
import com.northernwall.hadrian.service.ServiceNotUsesGetHandler;
import com.northernwall.hadrian.service.ServiceRefCreateHandler;
import com.northernwall.hadrian.service.ServiceRefDeleteHandler;
import com.northernwall.hadrian.service.ServicesGetHandler;
import com.northernwall.hadrian.service.TeamAddUserHandler;
import com.northernwall.hadrian.service.TeamCreateHandler;
import com.northernwall.hadrian.service.TeamGetHandler;
import com.northernwall.hadrian.service.TeamModifyHandler;
import com.northernwall.hadrian.service.TeamRemoveUserHandler;
import com.northernwall.hadrian.service.UserGetHandler;
import com.northernwall.hadrian.service.UserModifyHandler;
import com.northernwall.hadrian.service.VipCreateHandler;
import com.northernwall.hadrian.service.VipDeleteHandler;
import com.northernwall.hadrian.service.VipModifyHandler;
import com.northernwall.hadrian.service.WorkItemGetHandler;
import com.northernwall.hadrian.service.helper.HostDetailsHelper;
import com.northernwall.hadrian.service.helper.InfoHelper;
import com.northernwall.hadrian.tree.TreeHandler;
import com.northernwall.hadrian.utilityHandlers.AvailabilityHandler;
import com.northernwall.hadrian.utilityHandlers.ContentHandler;
import com.northernwall.hadrian.utilityHandlers.FaviconHandler;
import com.northernwall.hadrian.utilityHandlers.HealthHandler;
import com.northernwall.hadrian.utilityHandlers.MetricHandler;
import com.northernwall.hadrian.utilityHandlers.RedirectHandler;
import com.northernwall.hadrian.utilityHandlers.VersionHandler;
import com.northernwall.hadrian.utilityHandlers.routingHandler.MethodRule;
import com.northernwall.hadrian.utilityHandlers.routingHandler.RoutingHandler;
import com.northernwall.hadrian.utilityHandlers.routingHandler.TargetRule;
import com.northernwall.hadrian.workItem.WorkItemCallbackHandler;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.squareup.okhttp.OkHttpClient;
import java.net.BindException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadrian {
    private static final Logger logger = LoggerFactory.getLogger(Hadrian.class);
    private final Parameters parameters;
    private final ConfigHelper configHelper;
    private final DataAccess dataAccess;
    private final MetricRegistry metricRegistry;
    private final OkHttpClient client;
    private final MavenHelper mavenHelper;
    private final AccessHelper accessHelper;
    private final Handler accessHandler;
    private final CalendarHelper calendarHelper;
    private final WorkItemProcessor workItemProcess;
    private final InfoHelper infoHelper;
    private final HostDetailsHelper hostDetailsHelper;
    private int port;
    private Server server;

    Hadrian(Parameters parameters, OkHttpClient client, DataAccess dataAccess, MavenHelper mavenHelper, AccessHelper accessHelper, Handler accessHandler, CalendarHelper calendarHelper, WorkItemProcessor workItemProcess, MetricRegistry metricRegistry) {
        this.parameters = parameters;
        this.client = client;
        this.dataAccess = dataAccess;
        this.mavenHelper = mavenHelper;
        this.accessHelper = accessHelper;
        this.accessHandler = accessHandler;
        this.calendarHelper = calendarHelper;
        this.workItemProcess = workItemProcess;
        this.metricRegistry = metricRegistry;
        this.configHelper = new ConfigHelper(parameters);
        this.infoHelper = new InfoHelper(client);
        this.hostDetailsHelper = new HostDetailsHelper(client, parameters);
        this.setupJetty();
    }

    private void setupJetty() {
        this.port = this.parameters.getInt("jetty.port", 9090);
        this.server = new Server((ThreadPool)new QueuedThreadPool(10, 5));
        this.server.setStopAtShutdown(true);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
        connector.setPort(this.port);
        connector.setIdleTimeout((long)this.parameters.getInt("jetty.idleTimeout", 1000));
        connector.setAcceptQueueSize(this.parameters.getInt("jetty.idleTimeout", 100));
        this.server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        RoutingHandler routingHandler = new RoutingHandler();
        routingHandler.addUtilityRoute(MethodRule.GET, TargetRule.EQUALS, "/availability", (Handler)new AvailabilityHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/version", (Handler)new VersionHandler());
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/health", (Handler)new HealthHandler(this.accessHandler, this.calendarHelper, this.dataAccess, this.mavenHelper, this.parameters, this.workItemProcess.getWorkItemSender()));
        routingHandler.addUtilityRoute(MethodRule.GET, TargetRule.STARTS_WITH, "/ui/", (Handler)new ContentHandler("/webcontent"));
        routingHandler.addRoute(MethodRule.POST, TargetRule.STARTS_WITH, "/webhook/callback", (Handler)new WorkItemCallbackHandler(this.workItemProcess));
        routingHandler.addUtilityRoute(MethodRule.GET, TargetRule.EQUALS, "/favicon.ico", (Handler)new FaviconHandler());
        routingHandler.addUtilityRoute(MethodRule.ANY, TargetRule.ANY, "/", this.accessHandler);
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/config", (Handler)new ConfigGetHandler(this.configHelper));
        routingHandler.addUtilityRoute(MethodRule.GET, TargetRule.STARTS_WITH, "/ui/", (Handler)new ContentHandler("/webapp"));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/tree", (Handler)new TreeHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/users", (Handler)new UserGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/user/modify", (Handler)new UserModifyHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/team", (Handler)new TeamGetHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/create", (Handler)new TeamCreateHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/modify", (Handler)new TeamModifyHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/addUser", (Handler)new TeamAddUserHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/removeUser", (Handler)new TeamRemoveUserHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/services", (Handler)new ServicesGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/service", (Handler)new ServiceGetHandler(this.accessHelper, this.dataAccess, this.configHelper, this.mavenHelper, this.infoHelper));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/service/notuses", (Handler)new ServiceNotUsesGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/service/audit", (Handler)new ServiceAuditGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/service/auditOutput", (Handler)new ServiceAuditOutputGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/create", (Handler)new ServiceCreateHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/modify", (Handler)new ServiceModifyHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/delete", (Handler)new ServiceDeleteHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/createRef", (Handler)new ServiceRefCreateHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/deleteRef", (Handler)new ServiceRefDeleteHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/create", (Handler)new VipCreateHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/modify", (Handler)new VipModifyHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/delete", (Handler)new VipDeleteHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/create", (Handler)new ModuleCreateHandler(this.accessHelper, this.configHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/modify", (Handler)new ModuleModifyHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/delete", (Handler)new ModuleDeleteHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/host/details", (Handler)new HostGetDetailsHandler(this.dataAccess, this.hostDetailsHelper));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/create", (Handler)new HostCreateHandler(this.accessHelper, this.configHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/deploy", (Handler)new HostDeploySoftwareHandler(this.accessHelper, this.configHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/restart", (Handler)new HostRestartHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/delete", (Handler)new HostDeleteHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/backfill", (Handler)new HostBackfillHandler(this.accessHelper, this.configHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/hostvip/create", (Handler)new HostVipCreateHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/hostvip/delete", (Handler)new HostVipDeleteHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/cf/exec", (Handler)new CustomFuntionExecHandler(this.accessHelper, this.dataAccess, this.client));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/create", (Handler)new CustomFuntionCreateHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/modify", (Handler)new CustomFuntionModifyHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/delete", (Handler)new CustomFuntionDeleteHandler(this.accessHelper, this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/workitems", (Handler)new WorkItemGetHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/datastore", (Handler)new DataStoreGetHandler());
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/calendar", (Handler)new CalendarGetHandler(this.dataAccess, this.calendarHelper));
        routingHandler.addRoute(MethodRule.GET, TargetRule.EQUALS, "/v1/graph/all", (Handler)new GraphAllHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.MATCHES, "/v1/graph/fanin/\\w+-\\w+-\\w+-\\w+-\\w+", (Handler)new GraphFanInHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.GET, TargetRule.MATCHES, "/v1/graph/fanout/\\w+-\\w+-\\w+-\\w+-\\w+", (Handler)new GraphFanOutHandler(this.dataAccess));
        routingHandler.addRoute(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/audit", (Handler)new AuditCreateHandler(this.dataAccess, this.accessHelper));
        routingHandler.addRoute(MethodRule.ANY, TargetRule.ANY, "/", (Handler)new RedirectHandler());
        handlers.addHandler((Handler)routingHandler);
        MetricHandler metricHandler = new MetricHandler(handlers, this.metricRegistry);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)metricHandler);
        contextHandler.setContextPath("/");
        this.server.setHandler((Handler)contextHandler);
    }

    public void start() {
        try {
            this.server.start();
            logger.info("Jetty server started on port {}, joining with server thread now", (Object)this.port);
            this.server.join();
        }
        catch (BindException be) {
            logger.error("Can not bind to port {}, exiting", (Object)this.port);
            System.exit(0);
        }
        catch (Exception ex) {
            logger.error("Exception {} occured", (Object)ex.getMessage());
        }
    }
}

