/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.action.Action;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartHostAction
extends Action {
    private static final Logger logger = LoggerFactory.getLogger(RestartHostAction.class);

    public RestartHostAction(DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess, workItemProcessor);
    }

    @Override
    protected void success(WorkItem workItem) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(false, "-");
        this.dataAccess.updateHost(host);
        if (workItem.getNextId() == null) {
            return;
        }
        WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
        Host nextHost = this.dataAccess.getHost(nextWorkItem.getService().serviceId, nextWorkItem.getHost().hostId);
        if (nextHost == null) {
            logger.error("Finished restarting {}, next work item is {}, but could not find it.", (Object)workItem.getHost().hostId, (Object)nextWorkItem.getHost().hostId);
            return;
        }
        nextHost.setStatus(true, "Restarting...");
        this.dataAccess.saveHost(nextHost);
        this.workItemProcessor.sendWorkItem(nextWorkItem);
    }

    @Override
    protected void error(WorkItem workItem) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(false, "Last restart failed");
        this.dataAccess.updateHost(host);
        logger.warn("Callback for {} recorded a failure", (Object)workItem.getHost().hostId);
    }
}

