/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.action.Action;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHostAction
extends Action {
    private static final Logger logger = LoggerFactory.getLogger(CreateHostAction.class);

    public CreateHostAction(DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess, workItemProcessor);
    }

    @Override
    protected void success(WorkItem workItem) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        if (workItem.getNextId() != null) {
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(workItem.getNextId());
            if (nextWorkItem != null) {
                host.setStatus(true, "Deploying...");
                this.dataAccess.updateHost(host);
                this.workItemProcessor.sendWorkItem(nextWorkItem);
            } else {
                logger.warn("Odd, the deploy work item {} for create host {} could not be found", (Object)workItem.getNextId(), (Object)host.getHostName());
                host.setStatus(false, "-");
                this.dataAccess.updateHost(host);
            }
        } else {
            logger.warn("Odd, create host {} work item has no deploy work item id", (Object)host.getHostName());
        }
    }

    @Override
    protected void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        logger.warn("Callback for {} recorded a failure", (Object)host.getHostId());
        this.dataAccess.deleteHost(host);
    }
}

