/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.gson.Gson;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http404NotFoundException;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.WorkItemSender;
import com.northernwall.hadrian.workItem.action.CreateHostAction;
import com.northernwall.hadrian.workItem.action.DeploySoftwareAction;
import com.northernwall.hadrian.workItem.action.RestartHostAction;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemProcessorImpl
implements WorkItemProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemProcessor.class);
    private final DataAccess dataAccess;
    private final WorkItemSender workItemSender;
    private final MetricRegistry metricRegistry;
    private final Map<String, Timer> timerProcess;
    private final Timer timerCalback;
    private final Meter meterSuccess;
    private final Meter meterFail;
    private final Gson gson;
    private final CreateHostAction createHostAction;
    private final DeploySoftwareAction deploySoftwareAction;
    private final RestartHostAction restartHostAction;

    public WorkItemProcessorImpl(DataAccess dataAccess, WorkItemSender workItemSender, MetricRegistry metricRegistry) {
        this.dataAccess = dataAccess;
        this.workItemSender = workItemSender;
        this.metricRegistry = metricRegistry;
        this.timerProcess = new ConcurrentHashMap<String, Timer>();
        this.timerCalback = metricRegistry.timer("workItem.callback.process");
        this.meterSuccess = metricRegistry.meter("workItem.callback.success");
        this.meterFail = metricRegistry.meter("workItem.callback.fail");
        this.gson = new Gson();
        this.createHostAction = new CreateHostAction(dataAccess, this);
        this.deploySoftwareAction = new DeploySoftwareAction(dataAccess, this);
        this.restartHostAction = new RestartHostAction(dataAccess, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendWorkItem(WorkItem workItem) throws IOException {
        Result result;
        String key = (Object)((Object)workItem.getType()) + "." + (Object)((Object)workItem.getOperation());
        Timer timer = this.timerProcess.get(key);
        if (timer == null) {
            timer = this.metricRegistry.timer("workItem.send." + key);
            this.timerProcess.put(key, timer);
        }
        Timer.Context context = timer.time();
        try {
            result = this.workItemSender.sendWorkItem(workItem);
        }
        finally {
            context.stop();
        }
        switch (result) {
            case success: {
                logger.info("Work item sender says work item  {} has been process, no callback expected.", (Object)workItem.getId());
                this.meterSuccess.mark();
                break;
            }
            case error: {
                logger.warn("Work item sender says work item  {} failed to be process, no callback expected.", (Object)workItem.getId());
                this.meterFail.mark();
                break;
            }
            case wip: {
                logger.info("Work item sender says work item  {} is being processed.", (Object)workItem.getId());
                return;
            }
        }
        CallbackData callbackData = new CallbackData();
        callbackData.requestId = workItem.getId();
        callbackData.errorCode = 0;
        callbackData.errorDescription = " ";
        callbackData.status = result;
        callbackData.output = null;
        this.processCallback(callbackData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCallback(CallbackData callbackData) throws IOException {
        Timer.Context context = this.timerCalback.time();
        try {
            WorkItem workItem = this.dataAccess.getWorkItem(callbackData.requestId);
            if (workItem == null) {
                throw new Http404NotFoundException("Could not find work item " + callbackData.requestId);
            }
            if (callbackData.status == null) {
                throw new Http400BadRequestException("Callback is missing status, " + callbackData.requestId);
            }
            switch (callbackData.status) {
                case success: {
                    this.meterSuccess.mark();
                    break;
                }
                case error: {
                    this.meterFail.mark();
                    break;
                }
                case wip: {
                    logger.warn("ProcessCallback should never be called for WIP");
                    return;
                }
            }
            this.dataAccess.deleteWorkItem(callbackData.requestId);
            HashMap<String, String> notes = new HashMap<String, String>();
            block7 : switch (workItem.getType()) {
                case module: {
                    switch (workItem.getOperation()) {
                        case create: {
                            notes.put("Template", workItem.getMainModule().template);
                            notes.put("Type", workItem.getMainModule().moduleType.toString());
                            break block7;
                        }
                        case update: {
                            break block7;
                        }
                        case delete: {
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                case host: {
                    switch (workItem.getOperation()) {
                        case create: {
                            this.createHostAction.process(workItem, callbackData.status);
                            notes.put("DC", workItem.getHost().dataCenter);
                            notes.put("Network", workItem.getHost().network);
                            notes.put("Operating_Env", workItem.getHost().env);
                            notes.put("Size_CPU", Integer.toString(workItem.getHost().sizeCpu));
                            notes.put("Size_Memory", Integer.toString(workItem.getHost().sizeMemory));
                            notes.put("Size_Storage", Integer.toString(workItem.getHost().sizeStorage));
                            notes.put("Reason", workItem.getHost().reason);
                            break block7;
                        }
                        case deploy: {
                            this.deploySoftwareAction.process(workItem, callbackData.status);
                            if (workItem.getHost().version != null) {
                                notes.put("Version", workItem.getHost().version);
                            }
                            if (workItem.getHost().prevVersion != null) {
                                notes.put("Prev Version", workItem.getHost().prevVersion);
                            }
                            if (workItem.getHost().versionUrl != null) {
                                notes.put("Version Url", workItem.getHost().versionUrl);
                            }
                            if (workItem.getHost().configVersion != null) {
                                notes.put("Config_Version", workItem.getHost().configVersion);
                            }
                            notes.put("Reason", workItem.getHost().reason);
                            break block7;
                        }
                        case restart: {
                            this.restartHostAction.process(workItem, callbackData.status);
                            notes.put("Reason", workItem.getHost().reason);
                            break block7;
                        }
                        case delete: {
                            this.deleteHost(workItem, callbackData.status);
                            notes.put("Reason", workItem.getHost().reason);
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                case vip: {
                    switch (workItem.getOperation()) {
                        case create: {
                            notes.put("Protocol", workItem.getVip().protocol);
                            notes.put("DNS", workItem.getVip().dns + "." + workItem.getVip().domain);
                            notes.put("VIP_Port", Integer.toString(workItem.getVip().vipPort));
                            notes.put("Service_Port", Integer.toString(workItem.getVip().servicePort));
                            notes.put("External", Boolean.toString(workItem.getVip().external));
                            this.createVip(workItem, callbackData.status);
                            break block7;
                        }
                        case update: {
                            notes.put("Protocol", workItem.getVip().protocol);
                            notes.put("DNS", workItem.getVip().dns + "." + workItem.getVip().domain);
                            notes.put("VIP_Port", Integer.toString(workItem.getVip().vipPort));
                            notes.put("Service_Port", Integer.toString(workItem.getVip().servicePort));
                            notes.put("External", Boolean.toString(workItem.getVip().external));
                            this.updateVip(workItem, callbackData.status);
                            break block7;
                        }
                        case delete: {
                            this.deleteVip(workItem, callbackData.status);
                            break block7;
                        }
                    }
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
                default: {
                    throw new RuntimeException("Unknown callback " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
                }
            }
            Audit audit = new Audit();
            audit.serviceId = workItem.getService().serviceId;
            audit.timePerformed = GMT.getGmtAsDate();
            audit.timeRequested = workItem.getRequestDate();
            audit.requestor = workItem.getUsername();
            audit.type = workItem.getType();
            audit.operation = workItem.getOperation();
            boolean bl = audit.successfull = callbackData.status == Result.success;
            if (workItem.getMainModule() != null) {
                audit.moduleName = workItem.getMainModule().moduleName;
            }
            if (workItem.getHost() != null) {
                audit.hostName = workItem.getHost().hostName;
            }
            if (workItem.getVip() != null) {
                audit.vipName = workItem.getVip().dns;
            }
            audit.notes = notes.isEmpty() ? "" : this.gson.toJson(notes);
            this.dataAccess.saveAudit(audit, callbackData.output);
            if (callbackData.status == Result.error) {
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                this.deleteNextWorkItem(workItem.getNextId());
            } else {
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 200);
            }
        }
        finally {
            context.stop();
        }
    }

    private void deleteNextWorkItem(String nextId) {
        if (nextId != null) {
            WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
            this.deleteNextWorkItem(nextWorkItem.getNextId());
            WorkItem workItem = this.dataAccess.getWorkItem(nextId);
            if (workItem != null) {
                Host host;
                if (workItem.getType() == Type.host && (host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId)) != null) {
                    host.setStatus(false, "Last operation cancelled");
                    this.dataAccess.updateHost(host);
                }
                this.dataAccess.deleteWorkItem(nextId);
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                Audit audit = new Audit();
                audit.serviceId = workItem.getService().serviceId;
                audit.timePerformed = GMT.getGmtAsDate();
                audit.timeRequested = workItem.getRequestDate();
                audit.requestor = workItem.getUsername();
                audit.type = workItem.getType();
                audit.operation = workItem.getOperation();
                audit.successfull = false;
                if (workItem.getMainModule() != null) {
                    audit.moduleName = workItem.getMainModule().moduleName;
                }
                if (workItem.getHost() != null) {
                    audit.hostName = workItem.getHost().hostName;
                }
                if (workItem.getVip() != null) {
                    audit.vipName = workItem.getVip().dns;
                }
                audit.notes = "";
                this.dataAccess.saveAudit(audit, "Operation not preformed because an earlier operation in the sequence failed.");
            }
        }
    }

    private void deleteHost(WorkItem workItem, Result result) throws IOException {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            logger.warn("Could not find host {} to delete.", (Object)workItem.getHost().hostId);
            return;
        }
        if (result == Result.success) {
            this.dataAccess.deleteHost(host);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)host.getHostId(), (Object)result);
            host.setStatus(false, "-");
            this.dataAccess.updateHost(host);
        }
    }

    private void createVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being created", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)result);
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        }
    }

    private void updateVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.warn("Could not find vip {} being updated", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            vip.setStatus("-");
            vip.setExternal(workItem.getVip().external);
            vip.setServicePort(workItem.getVip().servicePort);
            this.dataAccess.updateVip(vip);
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)workItem.getVip().vipId, (Object)result);
        }
    }

    private void deleteVip(WorkItem workItem, Result result) throws IOException {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            logger.error("Could not find end point {} to delete.", (Object)workItem.getVip().vipId);
            return;
        }
        if (result == Result.success) {
            this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
        } else {
            logger.warn("Callback for {} failed with status {}", (Object)vip.getVipId(), (Object)result);
            vip.setStatus("-");
            this.dataAccess.updateVip(vip);
        }
    }
}

