/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.messaging.email;

import com.google.gson.Gson;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.messaging.MessageProcessor;
import com.northernwall.hadrian.messaging.MessageType;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import java.util.Map;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

public class EmailMessageProcessor
extends MessageProcessor {
    private String smtpHostname;
    private int smtpPort;
    private boolean smtpSsl;
    private DefaultAuthenticator authenticator = null;

    @Override
    public void init(Parameters parameters, Gson gson, OkHttpClient client) {
        this.smtpHostname = parameters.getString("emailWorkItem.smtp.hostname", null);
        this.smtpPort = parameters.getInt("emailWorkItem.smtp.port", 25);
        this.smtpSsl = parameters.getBoolean("emailWorkItem.smtp.ssl", false);
        String smtpUsername = parameters.getString("emailWorkItem.smtp.username", null);
        String smtpPassword = parameters.getString("emailWorkItem.smtp.password", null);
        if (smtpUsername != null && !smtpUsername.isEmpty() && smtpPassword != null && !smtpPassword.isEmpty()) {
            this.authenticator = new DefaultAuthenticator(smtpUsername, smtpPassword);
        }
    }

    @Override
    public void process(MessageType messageType, Team team, Map<String, String> data) {
        if (messageType == null || messageType.emailSubject == null || messageType.emailSubject.isEmpty() || messageType.emailBody == null || messageType.emailBody.isEmpty()) {
            return;
        }
        try {
            SimpleEmail email = new SimpleEmail();
            if (this.smtpHostname != null) {
                email.setHostName(this.smtpHostname);
            }
            email.setSmtpPort(this.smtpPort);
            if (this.authenticator != null) {
                email.setAuthenticator((Authenticator)this.authenticator);
            }
            email.setSSLOnConnect(this.smtpSsl);
            email.setFrom(team.getTeamEmail());
            email.setSubject(this.replaceTerms(messageType.emailSubject, data));
            email.setMsg(this.replaceTerms(messageType.emailBody, data));
            email.addTo(team.getTeamEmail());
            email.send();
        }
        catch (EmailException ex) {
            throw new RuntimeException("Failure emailing work item, {}", ex);
        }
    }
}

