/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.messaging;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.utility.HealthWriter;
import com.northernwall.hadrian.messaging.MessageProcessor;
import com.northernwall.hadrian.messaging.MessageType;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingCoodinator
implements ParameterChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(MessagingCoodinator.class);
    private final DataAccess dataAccess;
    private final Parameters parameters;
    private final List<MessageProcessor> messageProcessors;
    private final List<MessageType> messageTypes;
    private final Gson gson;

    public MessagingCoodinator(DataAccess dataAccess, Parameters parameters, OkHttpClient client) {
        this.dataAccess = dataAccess;
        this.parameters = parameters;
        this.messageProcessors = new LinkedList<MessageProcessor>();
        this.messageTypes = new LinkedList<MessageType>();
        this.gson = new Gson();
        String processors = parameters.getString("messageProcessors", "com.northernwall.hadrian.messaging.email.EmailMessageProcessor");
        if (processors != null && !processors.isEmpty()) {
            String[] parts;
            for (String part : parts = processors.split(",")) {
                try {
                    Class<?> c = Class.forName(part);
                    MessageProcessor processor = (MessageProcessor)c.newInstance();
                    processor.init(parameters, this.gson, client);
                    this.messageProcessors.add(processor);
                }
                catch (ClassNotFoundException ex) {
                    logger.warn("Could not find MessageProcessor class {}", (Object)part);
                }
                catch (InstantiationException ex) {
                    logger.warn("Could not instantiation MessageProcessor class {}", (Object)part);
                }
                catch (IllegalAccessException ex) {
                    logger.warn("Could not access MessageProcessor class {}", (Object)part);
                }
            }
        }
        parameters.registerChangeListener(this);
    }

    @Override
    public synchronized void onChange(List<String> keys) {
        this.messageTypes.clear();
        logger.info("Cache of MessageTypes has been cleared.");
    }

    public void sendMessage(MessageType messageType, Team team, Service service, Module module, Map<String, String> data) {
        logger.info("sendMessage {} to {} {} {}", new Object[]{messageType.name, team.getTeamName(), service.getServiceName(), module.getModuleName()});
        data.put("serviceName", service.getServiceName());
        data.put("moduleName", module.getModuleName());
        data.put("teamName", team.getTeamName());
        HashSet<Team> teams = new HashSet<Team>();
        teams.add(team);
        if (messageType.includeUsedBy) {
            this.processModuleRefs(module, messageType, teams);
        }
        this.processEachTeam(teams, messageType, data);
    }

    public void sendMessage(MessageType messageType, Team team, Service service, Map<String, String> data) {
        logger.info("sendMessage {} to {} {}", new Object[]{messageType.name, team.getTeamName(), service.getServiceName()});
        data.put("serviceName", service.getServiceName());
        data.put("teamName", team.getTeamName());
        HashSet<Team> teams = new HashSet<Team>();
        teams.add(team);
        String moduleNames = "(no modules)";
        if (messageType.includeUsedBy) {
            List<Module> modules = this.dataAccess.getModules(service.getServiceId());
            for (int i = 0; i < modules.size() - 1; ++i) {
                Module module = modules.get(i);
                moduleNames = i == 0 ? module.getModuleName() : (i == modules.size() - 1 ? (i == 1 ? moduleNames + " and " + module.getModuleName() : moduleNames + ", and " + module.getModuleName()) : moduleNames + ", " + module.getModuleName());
                this.processModuleRefs(module, messageType, teams);
            }
        }
        data.put("moduleName", moduleNames);
        this.processEachTeam(teams, messageType, data);
    }

    private void processModuleRefs(Module module, MessageType messageType, Set<Team> teams) {
        List<ModuleRef> refs = this.dataAccess.getModuleRefsByServer(module.getServiceId(), module.getModuleId());
        for (ModuleRef ref : refs) {
            Service tempService = this.dataAccess.getService(ref.getClientServiceId());
            Team tempTeam = this.dataAccess.getTeam(tempService.getTeamId());
            logger.info("also sending message {} to {}", (Object)messageType.name, (Object)tempTeam.getTeamName());
            teams.add(tempTeam);
        }
    }

    private void processEachTeam(Set<Team> teams, MessageType messageType, Map<String, String> data) {
        for (Team tempTeam : teams) {
            for (MessageProcessor messageProcessor : this.messageProcessors) {
                messageProcessor.process(messageType, tempTeam, data);
            }
        }
    }

    public synchronized MessageType getMessageType(String messageTypeName) {
        MessageType messageType2;
        for (MessageType messageType2 : this.messageTypes) {
            if (!messageType2.name.equalsIgnoreCase(messageTypeName)) continue;
            return messageType2;
        }
        String temp = this.parameters.getString("messageType." + messageTypeName, null);
        if (temp == null) {
            logger.warn("Could not find MessageType {}", (Object)messageTypeName);
            return null;
        }
        messageType2 = (MessageType)this.gson.fromJson(temp, MessageType.class);
        this.messageTypes.add(messageType2);
        return messageType2;
    }

    public void getHealth(HealthWriter writer) throws IOException {
        for (MessageProcessor messageProcessor : this.messageProcessors) {
            writer.addLine("MessageProcessor", messageProcessor.getClass().getCanonicalName());
        }
    }
}

