/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.workitem;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.workitem.dao.GetWorkItemData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class WorkItemGetHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final Gson gson;

    public WorkItemGetHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        GetWorkItemData getWorkItemData = new GetWorkItemData();
        List<WorkItem> workItems = this.dataAccess.getWorkItems();
        for (WorkItem workItem : workItems) {
            boolean found = false;
            for (WorkItem workItem2 : workItems) {
                if (!workItem.getId().equals(workItem2.getNextId())) continue;
                found = true;
            }
            if (found) continue;
            getWorkItemData.workItems.add(workItem);
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getWorkItemData, GetWorkItemData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

