/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility.routingHandler;

import com.northernwall.hadrian.handlers.utility.routingHandler.HttpAbstractException;
import com.northernwall.hadrian.handlers.utility.routingHandler.MethodRule;
import com.northernwall.hadrian.handlers.utility.routingHandler.RouteEntry;
import com.northernwall.hadrian.handlers.utility.routingHandler.TargetRule;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(RoutingHandler.class);
    private final List<RouteEntry> getRoutes = new LinkedList<RouteEntry>();
    private final List<RouteEntry> putRoutes = new LinkedList<RouteEntry>();
    private final List<RouteEntry> postRoutes = new LinkedList<RouteEntry>();
    private final List<RouteEntry> deleteRoutes = new LinkedList<RouteEntry>();

    public void add(MethodRule methodRule, TargetRule targetRule, String targetPattern, Handler handler, boolean logAccess) {
        RouteEntry entry = new RouteEntry(targetRule, targetPattern, handler, logAccess);
        switch (methodRule) {
            case GET: {
                this.getRoutes.add(entry);
                break;
            }
            case PUT: {
                this.putRoutes.add(entry);
                break;
            }
            case POST: {
                this.postRoutes.add(entry);
                break;
            }
            case DELETE: {
                this.deleteRoutes.add(entry);
                break;
            }
            case PUTPOST: {
                this.putRoutes.add(entry);
                this.postRoutes.add(entry);
                break;
            }
            case ANY: {
                this.getRoutes.add(entry);
                this.putRoutes.add(entry);
                this.postRoutes.add(entry);
                this.deleteRoutes.add(entry);
            }
        }
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        List<RouteEntry> routes;
        switch (request.getMethod()) {
            case "GET": {
                routes = this.getRoutes;
                break;
            }
            case "PUT": {
                routes = this.putRoutes;
                break;
            }
            case "POST": {
                routes = this.postRoutes;
                break;
            }
            case "DELETE": {
                routes = this.deleteRoutes;
                break;
            }
            default: {
                return;
            }
        }
        for (RouteEntry entry : routes) {
            if (!entry.targetRule.test(entry.targetPattern, target)) continue;
            try {
                if (entry.logAccess) {
                    logger.info("{} handling {} request for {}", new Object[]{entry.name, request.getMethod(), target});
                }
                entry.handler.handle(target, request, httpRequest, response);
                if (!request.isHandled()) continue;
                return;
            }
            catch (HttpAbstractException e) {
                logger.error("Exception '{}' while {} was handling {} request for {}", new Object[]{e.getMessage(), entry.name, request.getMethod(), target});
                response.getWriter().print(e.getMessage());
                response.setStatus(e.getStatus());
                request.setHandled(true);
                return;
            }
            catch (Exception e) {
                logger.error("Exception '{}' while {} was handling {} request for {}", new Object[]{e.getMessage(), entry.name, request.getMethod(), target, e});
                response.getWriter().print("Internal Server Error.");
                response.setStatus(500);
                request.setHandled(true);
                return;
            }
        }
        logger.info("Could not find a handler for {} {}", (Object)request.getMethod(), (Object)target);
    }
}

