/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;

public class MetricHandler
extends AbstractHandler {
    private final HandlerList handlers;
    private final Timer timerGet;
    private final Timer timerPost;
    private final Timer timerPut;
    private final Timer timerDelete;
    private final Meter meter200;
    private final Meter meter400;
    private final Meter meter500;

    public MetricHandler(HandlerList handlers, MetricRegistry metricRegistry) {
        this.handlers = handlers;
        this.timerGet = metricRegistry.timer("http.get");
        this.timerPost = metricRegistry.timer("http.post");
        this.timerPut = metricRegistry.timer("http.put");
        this.timerDelete = metricRegistry.timer("http.delete");
        this.meter200 = metricRegistry.meter("http.200");
        this.meter400 = metricRegistry.meter("http.400");
        this.meter500 = metricRegistry.meter("http.500");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Timer.Context context = null;
        switch (request.getMethod()) {
            case "GET": {
                context = this.timerGet.time();
                break;
            }
            case "POST": {
                context = this.timerPost.time();
                break;
            }
            case "PUT": {
                context = this.timerPut.time();
                break;
            }
            case "DELETE": {
                context = this.timerDelete.time();
            }
        }
        try {
            this.handlers.handle(target, request, httpRequest, response);
            if (response.getStatus() < 400) {
                this.meter200.mark();
            } else if (response.getStatus() < 500) {
                this.meter400.mark();
            } else {
                this.meter500.mark();
            }
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    public void setServer(Server server) {
        super.setServer(server);
        this.handlers.setServer(server);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.handlers.stop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handlers.start();
    }
}

