/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import com.northernwall.hadrian.handlers.utility.CachedContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ContentHandler.class);
    private final String rootPath;
    private final String indexPath;
    private final Map<String, CachedContent> cache;

    public ContentHandler(String rootPath) {
        this.rootPath = rootPath;
        this.indexPath = rootPath + "/index.html";
        this.cache = new ConcurrentHashMap<String, CachedContent>();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String path = target.equals("/ui/") ? this.indexPath : this.rootPath + target.substring(3);
        if (this.getContent(response, path)) {
            response.setStatus(200);
            request.setHandled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getContent(HttpServletResponse response, String resource) throws IOException {
        CachedContent content = this.cache.get(resource);
        if (content == null) {
            ContentHandler contentHandler = this;
            synchronized (contentHandler) {
                content = this.cache.get(resource);
                if (content == null) {
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);){
                        if (is == null) {
                            boolean bl = false;
                            return bl;
                        }
                        content = new CachedContent(is);
                        this.cache.put(resource, content);
                        logger.info("Loaded content {} into cache, {} bytes", (Object)resource, (Object)content.getSize());
                    }
                }
            }
        }
        if (resource.toLowerCase().endsWith(".html")) {
            response.addHeader("X-Frame-Options", "DENY");
            response.setContentType("text/html; charset=utf-8");
        }
        content.write(response.getOutputStream());
        return true;
    }
}

