/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.team;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.team.dao.PutTeamData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamModifyHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(TeamModifyHandler.class);
    private final AccessHelper accessHelper;

    public TeamModifyHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutTeamData data = this.fromJson(request, PutTeamData.class);
        Team team = this.getTeam(data.teamId, null);
        this.accessHelper.checkIfUserCanModify(request, data.teamId, "update team");
        data.teamName = data.teamName.trim();
        if (data.teamName.isEmpty()) {
            throw new Http400BadRequestException("Team Name is mising or empty");
        }
        if (data.teamName.length() > 30) {
            throw new Http400BadRequestException("Team Name is to long, max is 30");
        }
        if (data.gitGroup == null || data.gitGroup.isEmpty()) {
            throw new Http400BadRequestException("Git Group is mising or empty");
        }
        if (data.gitGroup.length() > 30) {
            throw new Http400BadRequestException("Git Group is to long, max is 30");
        }
        for (Team temp : this.getDataAccess().getTeams()) {
            if (temp.getTeamId().equals(data.teamId)) continue;
            if (temp.getTeamName().equals(data.teamName)) {
                throw new Http405NotAllowedException("Can not change team name, as a team with name " + data.teamName + " already exists");
            }
            if (!temp.getGitGroup().equals(data.gitGroup)) continue;
            logger.warn("Modifying team with name " + data.teamName + ", but it reuses another team's (" + temp.getTeamName() + ") GIT Group, " + data.gitGroup);
        }
        if (data.teamPage != null && data.teamPage.isEmpty() && !data.teamPage.toLowerCase().startsWith("http://") && !data.teamPage.toLowerCase().startsWith("https://")) {
            data.teamPage = "http://" + data.teamPage;
        }
        team.setTeamName(data.teamName);
        team.setTeamEmail(data.teamEmail);
        team.setTeamIrc(data.teamIrc);
        team.setTeamSlack(data.teamSlack);
        team.setGitGroup(data.gitGroup);
        team.setTeamPage(data.teamPage);
        team.setCalendarId(data.calendarId);
        team.setColour(data.colour);
        this.getDataAccess().saveTeam(team);
        response.setStatus(200);
        request.setHandled(true);
    }
}

