/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.team;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.team.dao.GetTeamData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class TeamGetHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public TeamGetHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Team team = this.getTeam(request);
        GetTeamData getTeamData = GetTeamData.create(team, this.getDataAccess());
        getTeamData.canModify = this.accessHelper.canUserModify(request, team.getTeamId());
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            TeamGetHandler.getGson().toJson((Object)getTeamData, GetTeamData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

