/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.team;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.team.dao.PostTeamAddUserData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http404NotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class TeamAddUserHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public TeamAddUserHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostTeamAddUserData data = this.fromJson(request, PostTeamAddUserData.class);
        Team team = this.getTeam(data.teamId, null);
        this.accessHelper.checkIfUserCanModify(request, data.teamId, "add user to team");
        if (this.getDataAccess().getUser(data.username) == null) {
            throw new Http404NotFoundException("Failed to add user " + data.username + " to team " + data.teamId + ", could not find user");
        }
        if (!team.getUsernames().contains(data.username)) {
            team.getUsernames().add(data.username);
            this.getDataAccess().updateTeam(team);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

