/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service.helper;

import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class InfoHelper {
    private final Parameters parameters;
    private final OkHttpClient client;

    public InfoHelper(Parameters parameters, OkHttpClient client) {
        this.parameters = parameters;
        this.client = client;
    }

    public int readAvailability(String host, String url) {
        if (url == null || url.isEmpty()) {
            return -1;
        }
        try {
            Request.Builder builder = new Request.Builder().url("http://" + url.replace("{host}", host));
            if (this.parameters.getUsername() != null && this.parameters.getUsername().isEmpty() && this.parameters.getPassword() != null && this.parameters.getPassword().isEmpty()) {
                builder.addHeader("Authorization", Credentials.basic((String)this.parameters.getUsername(), (String)this.parameters.getPassword()));
            }
            Request request = builder.build();
            Response response = this.client.newCall(request).execute();
            return response.code();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public String readVersion(String host, String url) {
        if (url == null || url.isEmpty()) {
            return "No Version URL";
        }
        try {
            Request request;
            Response response;
            Request.Builder builder = new Request.Builder().url("http://" + url.replace("{host}", host));
            if (this.parameters.getUsername() != null && this.parameters.getUsername().isEmpty() && this.parameters.getPassword() != null && this.parameters.getPassword().isEmpty()) {
                builder.addHeader("Authorization", Credentials.basic((String)this.parameters.getUsername(), (String)this.parameters.getPassword()));
            }
            if ((response = this.client.newCall(request = builder.build()).execute()).isSuccessful()) {
                return response.body().string();
            }
            return "Error: " + response.code();
        }
        catch (UnknownHostException ex) {
            return "Unknown Host";
        }
        catch (ConnectException | SocketTimeoutException ex) {
            return "Time Out";
        }
        catch (IOException ex) {
            return "IO Exception";
        }
    }
}

