/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.GetVersionData;
import com.northernwall.hadrian.handlers.service.helper.ReadModuleArtifactVersionsRunnable;
import com.northernwall.hadrian.handlers.service.helper.ReadModuleConfigVersionsRunnable;
import com.northernwall.hadrian.module.ModuleArtifactHelper;
import com.northernwall.hadrian.module.ModuleConfigHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class VersionsGetHandler
extends BasicHandler {
    private final ModuleArtifactHelper moduleArtifactHelper;
    private final ModuleConfigHelper moduleConfigHelper;
    private final ExecutorService executorService;

    public VersionsGetHandler(DataAccess dataAccess, ModuleArtifactHelper moduleArtifactHelper, ModuleConfigHelper moduleConfigHelper) {
        super(dataAccess);
        this.moduleArtifactHelper = moduleArtifactHelper;
        this.moduleConfigHelper = moduleConfigHelper;
        this.executorService = Executors.newFixedThreadPool(20);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        Service service = this.getService(request);
        Module module = this.getModule(request, service);
        GetVersionData data = new GetVersionData();
        Future<?> artifactFuture = this.executorService.submit(new ReadModuleArtifactVersionsRunnable(module, data, this.moduleArtifactHelper));
        Future<?> configFuture = this.executorService.submit(new ReadModuleConfigVersionsRunnable(module, data, this.moduleConfigHelper));
        while (!artifactFuture.isDone() || !configFuture.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            VersionsGetHandler.getGson().toJson((Object)data, GetVersionData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

